/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptInlayParameterHintsProvider
implements InlayParameterHintsProvider {
    public static final Option NAMES_FOR_ALL_ARGS = new Option("js.show.names.for.all.args", "Show name for all arguments", false);
    private static final Set<String> DEFAULT_BLACKLIST = ContainerUtil.immutableSet((Object[])new String[]{"(begin*, end*)", "(start*, end*)", "(first*, last*)", "(first*, second*)", "(from*, to*)", "(min*, max*)", "(key, value)", "(format, arg*)", "(message)", "(message, error)", "require(*)", "Error(*)", "*.set*(*)", "*.add(*)", "*.push(*)", "*.concat(*)", "*.join(*)", "*.forEach(*)", "*.map(*)", "*.reduce(*, *)", "*.set(*,*)", "*.filter(*)", "*.get(*)", "*.create(*)", "*.log(*)", "*.log(*, *)", "*.error(*)", "*.error(*, *)", "*.debug(*)", "*.debug(*, *)", "*.append(*)", "*.charAt(*)", "*.charCodeAt(*)", "*.indexOf(*, *)", "*.lastIndexOf(*, *)", "*.contains(*)", "*.startsWith(*)", "*.startsWith(*, *)", "*.endsWith(*)", "*.endsWith(*, *)"});

    @Nullable
    public HintInfo getHintInfo(@NotNull PsiElement element) {
        List<? extends JSFunctionItem> psiElements;
        if (element == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(0);
        }
        if ((psiElements = TypeScriptSignatureChooser.resolveFunctions(element)).size() != 1) {
            return null;
        }
        JSFunctionItem psiElement = psiElements.get(0);
        if (psiElement == null) {
            return null;
        }
        JSParameterItem[] parameters = psiElement.getParameters();
        if (parameters.length == 0) {
            return null;
        }
        List parameterNames = Arrays.stream(parameters).map(el -> el.getName()).collect(Collectors.toList());
        String qName = psiElement.getQualifiedName();
        if (qName != null) {
            return new HintInfo.MethodInfo(qName, parameterNames);
        }
        return null;
    }

    @NotNull
    public List<Option> getSupportedOptions() {
        List list = ContainerUtil.list((Object[])new Option[]{this.getShowNameForAllArgsOption()});
        if (list == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    protected Option getShowNameForAllArgsOption() {
        return NAMES_FOR_ALL_ARGS;
    }

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element) {
        JSParameterItem[] parameters;
        if (element == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(2);
        }
        if (!(element instanceof JSCallExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        boolean showAll = this.getShowNameForAllArgsOption().get();
        JSCallExpression callExpression = (JSCallExpression)element;
        List<? extends JSFunctionItem> functions = TypeScriptSignatureChooser.resolveFunctions(element);
        JSExpression[] arguments = callExpression.getArguments();
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (functions.size() == 0 || methodExpression == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        JSParameterItem[] jSParameterItemArray = parameters = functions.size() == 1 ? functions.get(0).getParameters() : JSUtils.getOverloadParameterList(methodExpression, functions, arguments);
        if (parameters.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        int toStop = Math.min(arguments.length, parameters.length);
        ArrayList list = ContainerUtil.newArrayListWithCapacity((int)toStop);
        for (int i = 0; i < toStop; ++i) {
            JSExpression argument = arguments[i];
            JSParameterItem parameter = parameters[i];
            if (!JavaScriptInlayParameterHintsProvider.shouldInlineParameterName((PsiElement)argument, parameter, showAll)) continue;
            list.add(this.createInlayInfo(argument, parameter));
        }
        ArrayList arrayList = list;
        if (arrayList == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public InlayInfo createInlayInfo(@NotNull JSExpression argument, @NotNull JSParameterItem parameter) {
        if (argument == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(7);
        }
        if (parameter == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(8);
        }
        InlayInfo inlayInfo = new InlayInfo(StringUtil.notNullize((String)parameter.getName()), argument.getTextOffset());
        if (inlayInfo == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(9);
        }
        return inlayInfo;
    }

    static boolean isLiteralOrUndefined(@Nullable PsiElement argument) {
        return argument instanceof JSLiteralExpression || argument instanceof JSPrefixExpression && ((JSPrefixExpression)argument).getExpression() instanceof JSLiteralExpression || argument instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)argument, "undefined");
    }

    private static boolean shouldInlineParameterName(@NotNull PsiElement argument, @NotNull JSParameterItem parameter, boolean showAll) {
        if (argument == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(10);
        }
        if (parameter == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(11);
        }
        if (parameter instanceof JSDestructuringParameter) {
            return false;
        }
        String name = parameter.getName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        if (showAll) {
            return true;
        }
        if (argument instanceof JSBinaryExpression || argument instanceof JSConditionalExpression || argument instanceof JSObjectLiteralExpression || argument instanceof JSArrayLiteralExpression || argument instanceof JSFunctionExpression && ((JSFunctionExpression)argument).getName() == null) {
            return true;
        }
        return !(argument instanceof JSXmlLiteralExpression) && JavaScriptInlayParameterHintsProvider.isLiteralOrUndefined(argument);
    }

    public String getBlacklistExplanationHTML() {
        return JSBundle.message((String)"ts.inlay.hints.blacklist.pattern.explanation", (Object[])new Object[0]);
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        Set<String> set = DEFAULT_BLACKLIST;
        if (set == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(12);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/JavaScriptInlayParameterHintsProvider";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/JavaScriptInlayParameterHintsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedOptions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterHints";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createInlayInfo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBlackList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHintInfo";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParameterHints";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInlayInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldInlineParameterName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

