/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.validity;

import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DuplicateCaseLabelJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("duplicate.case.label.display.name", new Object[0]);
        if (string == null) {
            DuplicateCaseLabelJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.VALIDITY_GROUP_NAME;
        if (string == null) {
            DuplicateCaseLabelJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("duplicate.case.label.error.string", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/validity/DuplicateCaseLabelJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSSwitchStatement(@NotNull JSSwitchStatement statement) {
            JSCaseClause[] clauses;
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSSwitchStatement(statement);
            HashSet<JSExpression> conditions = new HashSet<JSExpression>();
            Visitor.collectCaseLabels(statement, conditions);
            int numConditions = conditions.size();
            if (numConditions < 2) {
                return;
            }
            JSExpression[] conditionArray = conditions.toArray(new JSExpression[numConditions]);
            boolean[] matched = new boolean[conditionArray.length];
            Arrays.fill(matched, false);
            for (int i = 0; i < conditionArray.length; ++i) {
                if (matched[i]) continue;
                JSExpression condition = conditionArray[i];
                for (int j = i + 1; j < conditionArray.length; ++j) {
                    JSExpression testCondition;
                    boolean areEquivalent;
                    if (matched[j] || !(areEquivalent = EquivalenceChecker.expressionsAreEquivalent(condition, testCondition = conditionArray[j]))) continue;
                    this.registerError((PsiElement)testCondition);
                    if (!matched[i]) {
                        this.registerError((PsiElement)condition);
                    }
                    matched[i] = true;
                    matched[j] = true;
                }
            }
            int numDefaults = 0;
            for (JSCaseClause clause : clauses = statement.getCaseClauses()) {
                if (!clause.isDefault()) continue;
                ++numDefaults;
            }
            if (numDefaults > 1) {
                for (JSCaseClause clause : clauses) {
                    if (!clause.isDefault()) continue;
                    this.registerError(clause.getFirstChild());
                }
            }
        }

        private static void collectCaseLabels(JSSwitchStatement statement, Set<JSExpression> conditions) {
            JSCaseClause[] clauses;
            for (JSCaseClause clause : clauses = statement.getCaseClauses()) {
                JSExpression caseExpression;
                if (clause.isDefault() || (caseExpression = clause.getCaseExpression()) == null) continue;
                conditions.add(caseExpression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/validity/DuplicateCaseLabelJSInspection$Visitor", "visitJSSwitchStatement"));
        }
    }
}

