/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.model.Container;
import com.intellij.docker.agent.DockerAgentApplicationBase;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DockerAgentContainerImpl
extends DockerAgentApplicationBase {
    private final Container myContainer;

    DockerAgentContainerImpl(DockerAgentContext context, Container container) {
        super(context);
        this.myContainer = container;
        this.setContainerId(container.getId());
        this.setContainerLabels(Optional.ofNullable(container.getLabels()).orElseGet(HashMap::new));
    }

    @Nullable
    public String getPresentableName() {
        return DockerAgentImpl.appendAll(new StringBuilder(), this.myContainer.getNames()).toString();
    }

    @NotNull
    public String getUniqueName() {
        String string = this.getContainerId();
        if (string == null) {
            DockerAgentContainerImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getName() {
        return this.getUniqueName();
    }

    public String getContainerName() {
        String[] names = this.myContainer.getNames();
        return names == null || names.length == 0 ? null : new TreeSet<String>(Arrays.asList(names)).first();
    }

    public String getImageId() {
        return this.myContainer.getImage();
    }

    public String[] getImageRepoTags() {
        return null;
    }

    public String[] getContainerNames() {
        return this.myContainer.getNames();
    }

    public String getImageParentId() {
        return null;
    }

    public String getContainerStatus() {
        return this.myContainer.getStatus();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/agent/DockerAgentContainerImpl", "getUniqueName"));
    }
}

