/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlReferenceExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlIdentifierInspection
extends SqlInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.identifier", new Object[0]);
        if (string == null) {
            SqlIdentifierInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean isOnTheFly) {
        if (dialect == null) {
            SqlIdentifierInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlIdentifierInspection.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            SqlIdentifierInspection.$$$reportNull$$$0(3);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlReferenceExpression(SqlReferenceExpression o) {
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                if (o.resolve() == o) {
                    return;
                }
                super.visitSqlReferenceExpression(o);
            }

            public void visitSqlFunctionCallExpression(SqlFunctionCallExpression o) {
            }

            public void visitSqlIdentifier(SqlIdentifier o) {
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                if (!o.isPlainIdentifier()) {
                    return;
                }
                if (o.getParent() instanceof SqlParameter) {
                    return;
                }
                ProblemDescriptor problemDescriptor = this.myDialect.checkIdentifierText(o, this.myManager, isOnTheFly);
                if (problemDescriptor != null) {
                    this.addDescriptor(problemDescriptor);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlIdentifierInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlIdentifierInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

