/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.PsiTable;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlForeignKeyDefinition;
import com.intellij.sql.psi.SqlIndexDefinition;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTableKeyElementType;
import com.intellij.sql.psi.stubs.SqlTableStub;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCreateTableStatementImpl
extends SqlStubbedDefinitionImpl<SqlTableStub>
implements SqlCreateTableStatement {
    public SqlCreateTableStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public SqlCreateTableStatementImpl(SqlTableStub stub) {
        super(stub, SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT);
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_TABLE_REFERENCE;
    }

    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)super.getNameElement();
    }

    public SqlExpression getQueryExpression() {
        SqlTableStub stub = (SqlTableStub)this.getStub();
        if (stub != null) {
            return stub.getQueryExpression();
        }
        return (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_AS_QUERY_CLAUSE), SqlExpression.class);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlCreateTableStatement((SqlCreateTableStatement)this);
    }

    public DasDataSource getDataSource() {
        return null;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(1);
        }
        return objectKind;
    }

    @Override
    @NotNull
    public JBIterable<PsiObject> getDasChildren(@Nullable ObjectKind kind) {
        boolean all;
        JBIterable result2 = JBIterable.empty();
        boolean bl = all = kind == null || kind == ObjectKind.NONE;
        if (kind == ObjectKind.COLUMN || all) {
            result2 = result2.append(this.getColumns());
        }
        if (kind == ObjectKind.KEY || all) {
            result2 = result2.append(this.getDeclaredKeys());
        }
        if (kind == ObjectKind.FOREIGN_KEY || all) {
            result2 = result2.append(this.getDeclaredForeignKeys());
        }
        if (kind == ObjectKind.INDEX || all) {
            result2 = result2.append(this.getDeclaredIndices());
        }
        if (kind == ObjectKind.CHECK || all) {
            result2 = result2.append(this.getDeclaredChecks());
        }
        JBIterable jBIterable = result2;
        if (jBIterable == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public List<PsiColumn> getColumns() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcColumns(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    protected List<PsiColumn> calcColumns() {
        List list = ContainerUtil.concat((List[])new List[]{this.getDeclaredColumns(), this.getAdditionalColumns(), this.calcQueryColumns()});
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<SqlColumnDefinition> getDeclaredColumns() {
        List<PsiElement> list = Arrays.asList(this.getStubOrPsiChildren(SqlCompositeElementTypes.SQL_COLUMN_DEFINITION, SqlColumnDefinition.ARRAY_FACTORY));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<SqlTableKeyDefinition> getDeclaredKeys() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcDeclaredKeys(), (Object[])new Object[]{this}));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<SqlConstraintDefinition> getDeclaredChecks() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcDeclaredChecks(), (Object[])new Object[]{this}));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<SqlForeignKeyDefinition> getDeclaredForeignKeys() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcDeclaredForeignKeys(), (Object[])new Object[]{this}));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private List<SqlForeignKeyDefinition> calcDeclaredForeignKeys() {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (SqlColumnDefinition column2 : this.getDeclaredColumns()) {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)column2.getForeignKey());
        }
        ContainerUtil.addAll((Collection)result2, (Object[])this.getStubOrPsiChildren(SqlCompositeElementTypes.SQL_FOREIGN_KEY_DEFINITION, SqlForeignKeyDefinition.ARRAY_FACTORY));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private List<SqlTableKeyDefinition> calcDeclaredKeys() {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (SqlColumnDefinition sqlColumnDefinition : this.getDeclaredColumns()) {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)sqlColumnDefinition.getPrimaryKey());
        }
        SqlTableKeyElementType pkType = SqlCompositeElementTypes.SQL_PRIMARY_KEY_DEFINITION;
        ContainerUtil.addAll((Collection)result2, (Object[])this.getStubOrPsiChildren(pkType, SqlTableKeyDefinition.ARRAY_FACTORY));
        for (SqlColumnDefinition column3 : this.getDeclaredColumns()) {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)column3.getUniqueKey());
        }
        SqlTableKeyElementType sqlTableKeyElementType = SqlCompositeElementTypes.SQL_UNIQUE_CONSTRAINT_DEFINITION;
        Collections.addAll(result2, this.getStubOrPsiChildren(sqlTableKeyElementType, SqlTableKeyDefinition.ARRAY_FACTORY));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private List<SqlConstraintDefinition> calcDeclaredChecks() {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (SqlColumnDefinition column2 : this.getDeclaredColumns()) {
            for (SqlConstraintDefinition definition : column2.getConstraints()) {
                if (definition.getConstraintType() != SqlConstraintDefinition.Type.CHECK) continue;
                result2.add(definition);
            }
        }
        SqlImplUtil.childrenIt((PsiElement)this).filter(SqlConstraintDefinition.class).filter(c2 -> c2.getConstraintType() == SqlConstraintDefinition.Type.CHECK).addAllTo((Collection)result2);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public List<SqlIndexDefinition> getDeclaredIndices() {
        SqlTableKeyElementType idxType = SqlCompositeElementTypes.SQL_INDEX_DEFINITION;
        List<PsiElement> list = Arrays.asList(this.getStubOrPsiChildren(idxType, SqlIndexDefinition.ARRAY_FACTORY));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    public Icon getIcon() {
        return DatabaseIcons.Table;
    }

    @NotNull
    protected List<PsiColumn> getAdditionalColumns() {
        List list = ContainerUtil.emptyList();
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    protected List<PsiColumn> getQueryColumns() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcQueryColumns(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    protected List<PsiColumn> calcQueryColumns() {
        SqlType type;
        SqlExpression expression = this.getQueryExpression();
        SqlType sqlType = type = expression == null ? null : expression.getSqlType();
        if (!(type instanceof SqlTableType)) {
            List<PsiColumn> list = Collections.emptyList();
            if (list == null) {
                SqlCreateTableStatementImpl.$$$reportNull$$$0(15);
            }
            return list;
        }
        SqlTableType tableType = (SqlTableType)type;
        List<PsiColumn> list = SqlImplUtil.createColumnInfos((DasTable)this, tableType);
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    public boolean isSystem() {
        return false;
    }

    public boolean isTemporary() {
        return this.findChildByType((IElementType)SqlCommonKeywords.SQL_TEMPORARY) != null;
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn c2) {
        if (c2 == null) {
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                SqlCreateTableStatementImpl.$$$reportNull$$$0(17);
            }
            return set;
        }
        String name = c2.getName();
        EnumSet<DasColumn.Attribute> set = EnumSet.noneOf(DasColumn.Attribute.class);
        if (SqlImplUtil.getSqlDialectSafe((PsiElement)this).isAutoIncrementColumn(c2)) {
            set.add(DasColumn.Attribute.AUTO_GENERATED);
        }
        for (SqlTableKeyDefinition sqlTableKeyDefinition : this.getDeclaredKeys()) {
            if (!DasUtil.containsName((String)name, (MultiRef)sqlTableKeyDefinition.getColumnsRef())) continue;
            set.add(sqlTableKeyDefinition.isPrimary() ? DasColumn.Attribute.PRIMARY_KEY : DasColumn.Attribute.CANDIDATE_KEY);
        }
        for (DasForeignKey dasForeignKey : this.getDeclaredForeignKeys()) {
            if (!DasUtil.containsName((String)name, (MultiRef)dasForeignKey.getColumnsRef())) continue;
            set.add(DasColumn.Attribute.FOREIGN_KEY);
            break;
        }
        for (DasIndex dasIndex : this.getDeclaredIndices()) {
            if (!DasUtil.containsName((String)name, (MultiRef)dasIndex.getColumnsRef())) continue;
            set.add(DasColumn.Attribute.INDEX);
            break;
        }
        EnumSet<DasColumn.Attribute> enumSet = set;
        if (enumSet == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(18);
        }
        return enumSet;
    }

    protected boolean isColumnsCaseSensitive() {
        return DasUtil.isCaseSensitive((Casing)SqlImplUtil.getSqlDialectSafe((PsiElement)this).getCasing(ObjectKind.COLUMN, (DasObject)this));
    }

    @Override
    public boolean processImplicitContextDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, PsiElement place) {
        if (processor == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(19);
        }
        if (state == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(20);
        }
        if (!SqlImplUtil.isProcessingChildOf(processor, this.getKind())) {
            return true;
        }
        if (!PsiTreeUtil.isContextAncestor((PsiElement)this.getQueryExpression(), (PsiElement)place, (boolean)false)) {
            for (PsiColumn column2 : this.getQueryColumns()) {
                if (processor.execute((PsiElement)column2, state)) continue;
                return false;
            }
        }
        for (PsiColumn column2 : this.getAdditionalColumns()) {
            if (processor.execute((PsiElement)column2, state)) continue;
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    @NotNull
    protected List<PsiColumn> extractColumns(PsiTable element2) {
        SqlTableType tableType = SqlTableTypeBase.createType(element2, (PsiElement)this);
        List list = ContainerUtil.findAll(((TableBasedSqlTableTypeImpl)tableType).getColumns(), PsiColumn.class);
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcColumns";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredColumns";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredKeys";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredChecks";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredForeignKeys";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDeclaredForeignKeys";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDeclaredKeys";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDeclaredChecks";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredIndices";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalColumns";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryColumns";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "calcQueryColumns";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAttrs";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "extractColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitContextDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

