/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpspec;

import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpspec.PhpSpecSettingsManager;
import com.jetbrains.php.phpspec.PhpSpecUtil;
import com.jetbrains.php.testFramework.PhpTestCreateInfo;
import icons.PhpspecIcons;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSpecTestCreateInfo
implements PhpTestCreateInfo {
    public static final PhpSpecTestCreateInfo INSTANCE = new PhpSpecTestCreateInfo();
    public static final String PHPSPEC_TEST_METHOD_TEMPLATE_NAME = "PHPSpec Test Method";

    @NotNull
    public String getName() {
        if ("PHPSpec" == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(0);
        }
        return "PHPSpec";
    }

    @NotNull
    public String getTemplateName() {
        if ("PHPSpec Specification" == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(1);
        }
        return "PHPSpec Specification";
    }

    @Nullable
    public Icon getIcon() {
        return PhpspecIcons.Phpspec;
    }

    @NotNull
    public String getDefaultTestName(@NotNull String targetClassName) {
        if (targetClassName == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(2);
        }
        String string = targetClassName + "Spec";
        if (string == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Collection<String> getTestNamespaces(@NotNull Project project, @NotNull String namespace) {
        if (project == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(4);
        }
        if (namespace == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(5);
        }
        List list = ContainerUtil.map(PhpSpecSettingsManager.getInstance(project).getPrefixes(), prefix -> {
            if (namespace == null) {
                PhpSpecTestCreateInfo.$$$reportNull$$$0(12);
            }
            return PhpLangUtil.toPresentableFQN((String)PhpLangUtil.concat((String)prefix, (String)namespace));
        });
        if (list == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public String getTestMethodText(@NotNull Project project, @NotNull String classFqn, @NotNull String methodName) {
        if (project == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(7);
        }
        if (classFqn == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(8);
        }
        if (methodName == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(9);
        }
        String string = PhpCodeUtil.getCodeTemplate((String)PHPSPEC_TEST_METHOD_TEMPLATE_NAME, (Properties)this.getDefaultProperties(methodName, classFqn), (Project)project);
        if (string == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean canCreateTestFor(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(11);
        }
        return !PhpSpecUtil.isSpecTestClass(clazz.getProject(), clazz.getFQN());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpspec/PhpSpecTestCreateInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassName";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateName";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpspec/PhpSpecTestCreateInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTestName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNamespaces";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethodText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTestName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamespaces";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethodText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canCreateTestFor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTestNamespaces$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

