/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.tools.quality;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreterComboBox;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.run.deploymentAware.PhpRemoteToolCreateDialog;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolByInterpreterDialog<P, S extends P>
extends PhpRemoteToolCreateDialog<P, S, PhpInterpreterComboBox> {
    private final String myToolName;

    protected QualityToolByInterpreterDialog(@Nullable Project project, @NotNull List<P> settings, @NotNull String toolName) {
        if (settings == null) {
            QualityToolByInterpreterDialog.$$$reportNull$$$0(0);
        }
        if (toolName == null) {
            QualityToolByInterpreterDialog.$$$reportNull$$$0(1);
        }
        super(project, settings);
        this.myToolName = toolName;
        this.setTitle(PhpRemoteSdkBundle.message("quality.tool.configurable.by.interpreter.new.settings.dialog.title", this.myToolName));
        this.init();
    }

    protected void initComboBox() {
        this.myComboBox = new PhpInterpreterComboBox(this.myProject, PhpRemoteSdkAdditionalData.getRemoteSdkFilter());
        ((PhpInterpreterComboBox)this.myComboBox).reset();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myComboBox);
    }

    protected String getLabelText() {
        return PhpRemoteSdkBundle.message("quality.tool.configurable.by.interpreter.dialog.label", new Object[0]);
    }

    @Nullable
    public String getSelectedInterpreterName() {
        return ((PhpInterpreterComboBox)this.myComboBox).getSelectedItemName();
    }

    @Nullable
    protected abstract String getInterpreterId(@NotNull S var1);

    @Nullable
    protected ValidationInfo doValidate() {
        String selectedInterpreterId;
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance((Project)this.myProject);
        PhpSdkAdditionalData data = manager.findInterpreterDataById(selectedInterpreterId = manager.findInterpreterId(((PhpInterpreterComboBox)this.myComboBox).getSelectedItemName()));
        if (!(data instanceof PhpRemoteSdkAdditionalData)) {
            String message = PhpRemoteSdkBundle.message("quality.tool.configurable.by.interpreter.settings.select.server", this.myToolName);
            return new ValidationInfo(message, (JComponent)this.myComboBox);
        }
        PhpRemoteInterpreterManager remoteManager = PhpRemoteInterpreterManager.getInstance();
        if (remoteManager != null && !remoteManager.canRunBackgroundTool(this.myProject, data)) {
            CredentialsType type = ((PhpRemoteSdkAdditionalData)data).getRemoteConnectionType();
            String message = PhpBundle.message((String)"quality.tool.configurable.by.interpreter.selected.is.not.supported", (Object[])new Object[]{type.getName(), this.myToolName});
            return new ValidationInfo(message, (JComponent)this.myComboBox);
        }
        for (Object configuration : this.mySettings) {
            if (!StringUtil.equals((CharSequence)selectedInterpreterId, (CharSequence)this.getInterpreterId(configuration))) continue;
            String message = PhpRemoteSdkBundle.message("quality.tool.configurable.by.interpreter.settings.already.exist", this.myToolName);
            return new ValidationInfo(message, (JComponent)this.myComboBox);
        }
        return super.doValidate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "toolName";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/remote/tools/quality/QualityToolByInterpreterDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

