/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.arrangement;

import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.arrangement.PhpArrangementGrouper;
import com.jetbrains.php.arrangement.PhpElementArrangementEntry;
import com.jetbrains.php.arrangement.PhpElementArrangementEntryBase;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArrangementInfo {
    private final Map<PsiElement, PhpElementArrangementEntryBase> myMethodToEntry = new THashMap();
    private final List<PhpElementArrangementEntryBase> myEntries = new ArrayList<PhpElementArrangementEntryBase>();
    private final List<PhpArrangementGrouper> myArrangementGroupers = new SmartList();

    public PhpArrangementInfo(@Nullable List<? extends ArrangementGroupingRule> groupingRules) {
        if (groupingRules != null) {
            for (ArrangementGroupingRule arrangementGroupingRule : groupingRules) {
                PhpArrangementGrouper grouper = PhpArrangementGrouper.createInstance(arrangementGroupingRule);
                if (grouper == null) continue;
                this.myArrangementGroupers.add(grouper);
            }
        }
    }

    @Nullable
    public PhpElementArrangementEntryBase getEntry(@NotNull PsiElement element) {
        if (element == null) {
            PhpArrangementInfo.$$$reportNull$$$0(0);
        }
        return this.myMethodToEntry.get(element);
    }

    @NotNull
    public List<PhpElementArrangementEntryBase> getEntries(@NotNull PsiElement[] elements) {
        if (elements == null) {
            PhpArrangementInfo.$$$reportNull$$$0(1);
        }
        ArrayList entries = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            PhpElementArrangementEntryBase entry = this.myMethodToEntry.get(element);
            if (entry == null) continue;
            entries.add(entry);
        }
        ArrayList arrayList = entries;
        if (arrayList == null) {
            PhpArrangementInfo.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public List<PhpElementArrangementEntryBase> getEntries() {
        return this.myEntries;
    }

    public void updateGroupDependencies() {
        for (PhpArrangementGrouper builder : this.myArrangementGroupers) {
            builder.addGroupingDependencies(this);
        }
    }

    public void registerMethod(@NotNull Method method, @NotNull PhpElementArrangementEntry entry, @Nullable PhpElementArrangementEntry parent) {
        if (method == null) {
            PhpArrangementInfo.$$$reportNull$$$0(3);
        }
        if (entry == null) {
            PhpArrangementInfo.$$$reportNull$$$0(4);
        }
        this.registerEntry((PsiElement)method, entry, parent);
        this.myMethodToEntry.put((PsiElement)method, entry);
        for (PhpArrangementGrouper builder : this.myArrangementGroupers) {
            builder.registerMethod(method, entry);
        }
    }

    public void registerField(@NotNull Field field, @NotNull PhpElementArrangementEntry entry, @Nullable PhpElementArrangementEntry parent) {
        if (field == null) {
            PhpArrangementInfo.$$$reportNull$$$0(5);
        }
        if (entry == null) {
            PhpArrangementInfo.$$$reportNull$$$0(6);
        }
        this.registerEntry((PsiElement)field, entry, parent);
        for (PhpArrangementGrouper builder : this.myArrangementGroupers) {
            builder.registerField(field, entry);
        }
    }

    public void registerEntry(@NotNull PsiElement element, @NotNull PhpElementArrangementEntryBase entry, @Nullable PhpElementArrangementEntryBase parent) {
        if (element == null) {
            PhpArrangementInfo.$$$reportNull$$$0(7);
        }
        if (entry == null) {
            PhpArrangementInfo.$$$reportNull$$$0(8);
        }
        if (element instanceof PhpClass) {
            for (PhpArrangementGrouper grouper : this.myArrangementGroupers) {
                grouper.registerClass((PhpClass)element, entry);
            }
        }
        if (parent == null) {
            this.myEntries.add(entry);
        } else {
            parent.addChild((ArrangementEntry)entry);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/arrangement/PhpArrangementInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/arrangement/PhpArrangementInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEntry";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEntries";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerMethod";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerField";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

