/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.addDependency;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ComposerPackage {
    private static final String SEPARATOR = ":::::";
    public static final Comparator<ComposerPackage> NAMES_COMPARATOR = (o1, o2) -> o1.getName().compareTo(o2.getName());
    public static final Comparator<String> VERSIONS_COMPARATOR = (o1, o2) -> {
        o1 = StringUtil.notNullize((String)o1);
        o2 = StringUtil.notNullize((String)o2);
        List parts1 = StringUtil.split((String)o1, (String)".");
        List parts2 = StringUtil.split((String)o2, (String)".");
        for (int i = 0; i < Math.min(parts1.size(), parts2.size()); ++i) {
            String part2;
            String part1 = ((String)parts1.get(i)).trim();
            if (part1.equals(part2 = ((String)parts2.get(i)).trim())) continue;
            int number1 = -1;
            int number2 = -1;
            try {
                number1 = Integer.parseInt(part1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                number2 = Integer.parseInt(part2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (number1 == -1 && number2 == -1) {
                return -part1.compareTo(part2);
            }
            if (number1 != -1 && number2 == -1) {
                return -1;
            }
            if (number1 == -1 && number2 != -1) {
                return 1;
            }
            if (number1 == number2) continue;
            return -number1 + number2;
        }
        return -parts1.size() + parts2.size();
    };
    private final String myName;
    private final List<String> myVersions;
    private String myDescription;

    public ComposerPackage(@NonNls @NotNull String name, @NotNull List<String> versions, @NonNls @NotNull String description) {
        if (name == null) {
            ComposerPackage.$$$reportNull$$$0(0);
        }
        if (versions == null) {
            ComposerPackage.$$$reportNull$$$0(1);
        }
        if (description == null) {
            ComposerPackage.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.myVersions = versions;
        this.myDescription = description;
    }

    public String getName() {
        return this.myName;
    }

    public List<String> getVersions() {
        return this.myVersions;
    }

    public String getDescription() {
        return this.myDescription;
    }

    @NonNls
    public String toString() {
        return "ComposerPackage{myName='" + this.myName + '\'' + ", myVersions=" + this.myVersions + ", myDescription='" + this.myDescription + '\'' + '}';
    }

    public static String writePackage(ComposerPackage aPackage) {
        StringBuilder sb = new StringBuilder();
        sb.append(aPackage.getName());
        sb.append(" ").append(SEPARATOR).append(" ");
        boolean first = true;
        for (String s : aPackage.getVersions()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(s);
        }
        sb.append(" ").append(SEPARATOR).append(" ");
        sb.append(aPackage.getDescription());
        return sb.toString();
    }

    private static ComposerPackage readPackage(String line) throws InvalidDataException {
        List parts = StringUtil.split((String)line, (String)SEPARATOR);
        if (parts.size() != 3) {
            throw new InvalidDataException(PhpBundle.message("framework.composer.expected.name.0.versions.0.description.got.1", SEPARATOR, line));
        }
        String name = ((String)parts.get(0)).trim();
        if (name.isEmpty()) {
            throw new InvalidDataException(PhpBundle.message("framework.composer.empty.package.name.in.0", line));
        }
        String description = ((String)parts.get(2)).trim();
        List versions = StringUtil.split((String)((String)parts.get(1)), (String)",");
        if (versions.isEmpty()) {
            throw new InvalidDataException(PhpBundle.message("framework.composer.no.package.versions.in.0", line));
        }
        ArrayList<String> parsedVersions = new ArrayList<String>(versions.size());
        for (String version : versions) {
            if ((version = version.trim()).isEmpty()) continue;
            parsedVersions.add(version);
        }
        return new ComposerPackage(name, parsedVersions, description);
    }

    public static List<ComposerPackage> loadPackages(String[] lines) throws InvalidDataException {
        ArrayList<ComposerPackage> result = new ArrayList<ComposerPackage>(lines.length);
        for (String line : lines) {
            result.add(ComposerPackage.readPackage(line));
        }
        return result;
    }

    public void addVersions(ComposerPackage aPackage) {
        for (String s : aPackage.getVersions()) {
            if (this.myVersions.contains(s)) continue;
            this.myVersions.add(s);
        }
        if (aPackage.getDescription().length() > this.getDescription().length()) {
            this.myDescription = aPackage.getDescription();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "versions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "description";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/composer/addDependency/ComposerPackage";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

