/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpInputMessage;
import java.io.IOException;
import org.jdom.Element;

public class InitNotification
extends DbgpInputMessage {
    public static final String IDE_KEY_ATTR = "idekey";
    public static final String SESSION_ATTR = "session";
    public static final String THREAD_ATTR = "thread";
    public static final String PARENT_ATTR = "parent";
    public static final String LANG_ATTR = "language";
    public static final String PROTOCOL_VERSION_ATTR = "protocol_version";
    public static final String FILE_URI_ATTR = "fileuri";
    private static final String ENGINE_ELEMENT = "engine";
    private String mySessionId;
    private String myFileUri;
    private String myEngineVersion;

    public String getSessionId() {
        return this.mySessionId;
    }

    public String getFileUri() {
        return this.myFileUri;
    }

    public String getEngineVersion() {
        return this.myEngineVersion;
    }

    @Override
    public DbgpInputMessage deserialize(Element packet) throws IOException {
        this.mySessionId = StringUtil.notNullize((String)packet.getAttributeValue(IDE_KEY_ATTR));
        this.myFileUri = DbgpUtil.decodeUrl(packet.getAttributeValue(FILE_URI_ATTR));
        Element element = packet.getChild(ENGINE_ELEMENT, DbgpUtil.DBGP_NAMESPACE);
        if (element == null) {
            throw new IOException("Cannot find <engine> child");
        }
        this.myEngineVersion = element.getAttributeValue("version");
        return this;
    }
}

