/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.findUsages.PhpGotoTargetRendererProvider;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpElementWithModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLineMarkerProvider
extends LineMarkerProviderDescriptor {
    private static final Comparator<PhpNamedElement> PHP_NAMED_ELEMENT_COMPARATOR = Comparator.comparing(PhpNamedElement::getFQN);
    private final DaemonCodeAnalyzerSettings myDaemonSettings;
    private final EditorColorsManager myColorsManager;
    public static final String SPACE = "&nbsp;";
    public static final String BREAK = "<br>";

    public PhpLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    @Nullable
    public String getName() {
        return "Extends/Implements/Overrides";
    }

    private static void findChildren(PhpNamedElement element, Collection<LineMarkerInfo> markers) {
        Project project = element.getProject();
        if (element instanceof PhpClass) {
            PsiElement identifier;
            Collection subclasses;
            Icon icon = ((PhpClass)element).isInterface() ? PhpIcons.IMPLEMENTED : PhpIcons.OVERRIDEN;
            PhpClass clazz = (PhpClass)element;
            PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
            Collection collection = subclasses = clazz.isTrait() ? phpIndex.getTraitUsages(clazz) : phpIndex.getAllSubclasses(clazz.getFQN());
            if (!subclasses.isEmpty() && (identifier = element.getNameIdentifier()) != null) {
                markers.add(new LineMarkerInfo(identifier, identifier.getTextRange(), icon, 11, (com.intellij.util.Function)new OverridenTooltipGenerator(subclasses, (PsiElement)element, project), (GutterIconNavigationHandler)new PhpGutterIconNavigationHandler(subclasses, PhpLineMarkerProvider.getChildTitle(element), PhpLineMarkerProvider.getPinTitle(element), project), GutterIconRenderer.Alignment.LEFT));
            }
        } else if (element instanceof Method || element instanceof Field) {
            MyHierarchyMemberProcessor memberProcessor = new MyHierarchyMemberProcessor(false);
            PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
            PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)((PhpClassMember)element), (PhpIndex)phpIndex, (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)memberProcessor);
            if (!memberProcessor.myMembers.isEmpty()) {
                Collections.sort(memberProcessor.myMembers, PHP_NAMED_ELEMENT_COMPARATOR);
                PsiElement identifier = element.getNameIdentifier();
                if (identifier != null) {
                    markers.add(new LineMarkerInfo(identifier, identifier.getTextRange(), memberProcessor.icon, 11, (com.intellij.util.Function)new OverridenTooltipGenerator(memberProcessor.myMembers, (PsiElement)element, project), (GutterIconNavigationHandler)new PhpGutterIconNavigationHandler(memberProcessor.myMembers, PhpLineMarkerProvider.getChildTitle(element), PhpLineMarkerProvider.getPinTitle(element), project), GutterIconRenderer.Alignment.LEFT));
                }
            }
        }
    }

    private static String getChildTitle(PhpNamedElement element) {
        return element instanceof PhpClass && ((PhpClass)element).isInterface() ? PhpBundle.message("gutter.overriden.select.implementation.title", element.getName()) : PhpBundle.message("gutter.overriden.select.subclass.title", element.getName());
    }

    private static String getPinTitle(PhpNamedElement element) {
        return element instanceof PhpClass && ((PhpClass)element).isInterface() ? PhpBundle.message("gutter.pin.overriden.select.implementation.title", element.getName()) : PhpBundle.message("gutter.pin.overriden.select.subclass.title", element.getName());
    }

    private static void findParents(PhpNamedElement element, Collection<LineMarkerInfo> markers) {
        if (element instanceof Method || element instanceof Field) {
            PsiElement identifier;
            MyHierarchyMemberProcessor memberProcessor = new MyHierarchyMemberProcessor(true);
            PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)((PhpClassMember)element), (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)memberProcessor);
            if (!memberProcessor.myMembers.isEmpty() && (identifier = element.getNameIdentifier()) != null) {
                Project project = identifier.getProject();
                markers.add(new LineMarkerInfo(identifier, identifier.getTextRange(), memberProcessor.icon, 11, (com.intellij.util.Function)new OverridesTooltipGenerator(memberProcessor.myMembers, project), (GutterIconNavigationHandler)new PhpGutterIconNavigationHandler(memberProcessor.myMembers, PhpBundle.message("gutter.overriding.select.title", new Object[0]), PhpBundle.message("gutter.pin.overriding.select.title", element.getName()), project), GutterIconRenderer.Alignment.LEFT));
            }
        }
    }

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            PhpLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (this.myDaemonSettings.SHOW_METHOD_SEPARATORS && element instanceof Function) {
            Function function = (Function)element;
            if (StringUtil.isEmpty((String)function.getName()) || function instanceof PhpDocMethod) {
                return null;
            }
            return this.getLineMarker((PhpNamedElement)element);
        }
        if (element instanceof PhpClass && !((PhpClass)element).isAnonymous() || element instanceof PhpNamespace) {
            return this.getLineMarker((PhpNamedElement)element);
        }
        return null;
    }

    private LineMarkerInfo getLineMarker(@NotNull PhpNamedElement namedElement) {
        PhpDocComment comment;
        PsiElement element;
        if (namedElement == null) {
            PhpLineMarkerProvider.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = element = (comment = namedElement.getDocComment()) != null ? comment.getFirstChild() : namedElement.getFirstChild();
        if (element instanceof PhpModifierList) {
            if ((element = element.getFirstChild()) == null) {
                element = PhpPsiUtil.getChildOfType((PsiElement)namedElement, PhpTokenTypes.kwFUNCTION);
            }
        } else if (element instanceof FunctionReference) {
            element = element.getFirstChild();
        }
        if (element == null) {
            return null;
        }
        LineMarkerInfo info = new LineMarkerInfo(element, element.getTextRange(), null, 11, null, null, GutterIconRenderer.Alignment.RIGHT);
        EditorColorsScheme scheme = this.myColorsManager.getGlobalScheme();
        info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.TOP;
        return info;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            PhpLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            PhpLineMarkerProvider.$$$reportNull$$$0(3);
        }
        for (PsiElement element : elements) {
            if (!(element instanceof PhpNamedElement)) continue;
            PhpLineMarkerProvider.findChildren((PhpNamedElement)element, result);
            PhpLineMarkerProvider.findParents((PhpNamedElement)element, result);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/PhpLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarker";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyHierarchyMemberProcessor
    implements PhpClassHierarchyUtils.HierarchyClassMemberProcessor {
        private Icon icon;
        private final ArrayList<PhpClassMember> myMembers = new ArrayList();
        private final boolean up;

        MyHierarchyMemberProcessor(boolean up) {
            this.up = up;
        }

        public boolean process(PhpClassMember member, PhpClass subClass, PhpClass baseClass) {
            if (member instanceof Field) {
                Boolean isConstant = ((Field)member).isConstant();
                Field superField = baseClass.findOwnFieldByName((CharSequence)member.getName(), isConstant.booleanValue());
                if (superField != null && MyHierarchyMemberProcessor.isAnyPrivate(member, (PhpClassMember)superField)) {
                    return false;
                }
                if (subClass.isInterface() || baseClass.isInterface()) {
                    return false;
                }
                this.icon = this.up ? PhpIcons.OVERRIDES : PhpIcons.OVERRIDEN;
                this.myMembers.add(member);
                return true;
            }
            if (member instanceof Method) {
                boolean b;
                Method superMethod = baseClass.findOwnMethodByName((CharSequence)member.getName());
                if (superMethod != null && MyHierarchyMemberProcessor.isAnyPrivate(member, (PhpClassMember)superMethod)) {
                    return false;
                }
                boolean bl = b = baseClass.isInterface() == subClass.isInterface();
                this.icon = this.up ? (b ? PhpIcons.OVERRIDES : PhpIcons.IMPLEMENTS) : (b ? PhpIcons.OVERRIDEN : PhpIcons.IMPLEMENTED);
                this.myMembers.add(member);
                return true;
            }
            return false;
        }

        private static boolean isAnyPrivate(PhpClassMember member, PhpClassMember superMember) {
            PhpModifier.Access superAccess = superMember.getModifier().getAccess();
            PhpModifier.Access childAccess = member.getModifier().getAccess();
            return childAccess.isPrivate() || superAccess.isPrivate();
        }
    }

    public static class PhpGutterIconNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        private final Collection<? extends SmartPsiElementPointer<? extends PhpNamedElement>> myList;
        private final String myTitle;
        private final String myPinTitle;

        PhpGutterIconNavigationHandler(Collection<? extends PhpNamedElement> list, String title, String pinTitle, Project project) {
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
            this.myList = StreamEx.of(list).map(arg_0 -> ((SmartPointerManager)manager).createSmartPsiElementPointer(arg_0)).toList();
            this.myTitle = title;
            this.myPinTitle = pinTitle;
        }

        public void navigate(MouseEvent e, PsiElement __) {
            NavigatablePsiElement[] na = (NavigatablePsiElement[])StreamEx.of(this.myList).map(SmartPsiElementPointer::getElement).nonNull().toArray((Object[])NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY);
            PhpGotoTargetRendererProvider.PhpNamedElementPsiElementListCellRenderer renderer = new PhpGotoTargetRendererProvider.PhpNamedElementPsiElementListCellRenderer(false);
            PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])na, (String)this.myTitle, (String)this.myPinTitle, (ListCellRenderer)((Object)renderer));
        }
    }

    private static class OverridesTooltipGenerator
    implements com.intellij.util.Function<PsiElement, String> {
        private final Collection<? extends SmartPsiElementPointer<? extends PhpNamedElement>> myElements;

        private OverridesTooltipGenerator(Collection<? extends PhpNamedElement> elements, Project project) {
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
            this.myElements = StreamEx.of(elements).map(arg_0 -> ((SmartPointerManager)manager).createSmartPsiElementPointer(arg_0)).toList();
        }

        public String fun(PsiElement identifier) {
            StringBuilder buffer = new StringBuilder();
            for (SmartPsiElementPointer<? extends PhpNamedElement> smartPsiElementPointer : this.myElements) {
                PhpNamedElement element = (PhpNamedElement)smartPsiElementPointer.getElement();
                if (element == null) continue;
                buffer.append(((PhpElementWithModifier)element).getModifier().isAbstract() ? "Implements" : "Overrides");
                PsiElement parent = identifier.getParent();
                if (parent instanceof Method) {
                    buffer.append(PhpLineMarkerProvider.SPACE).append("method").append(PhpLineMarkerProvider.SPACE).append("in").append(PhpLineMarkerProvider.SPACE);
                } else {
                    buffer.append(PhpLineMarkerProvider.SPACE).append("field").append(PhpLineMarkerProvider.SPACE).append("in").append(PhpLineMarkerProvider.SPACE);
                }
                PhpNamedElement container = (PhpNamedElement)PhpPsiUtil.getParentByCondition((PsiElement)element, false, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                buffer.append(container != null && ((PhpClass)container).isInterface() ? "interface" : "class").append(PhpLineMarkerProvider.SPACE);
                if (container != null) {
                    buffer.append("'").append(container.getName()).append("'");
                } else {
                    buffer.append("unknown place");
                }
                buffer.append(PhpLineMarkerProvider.BREAK);
            }
            return buffer.toString();
        }
    }

    private static class OverridenTooltipGenerator
    implements com.intellij.util.Function<PsiElement, String> {
        private final Collection<? extends SmartPsiElementPointer<? extends PhpNamedElement>> myElements;
        private final SmartPsiElementPointer<PsiElement> myElement;

        OverridenTooltipGenerator(Collection<? extends PhpNamedElement> elements, PsiElement element, Project project) {
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
            this.myElements = StreamEx.of(elements).map(arg_0 -> ((SmartPointerManager)manager).createSmartPsiElementPointer(arg_0)).toList();
            this.myElement = manager.createSmartPsiElementPointer(element);
        }

        public String fun(PsiElement __) {
            StringBuilder buffer = new StringBuilder();
            PsiElement element = this.myElement.getElement();
            if (this.myElements.size() < 6) {
                PhpClass superclass;
                buffer.append("Is").append(PhpLineMarkerProvider.SPACE);
                TreeSet elements = new TreeSet(PHP_NAMED_ELEMENT_COMPARATOR);
                StreamEx.of(this.myElements).map(SmartPsiElementPointer::getElement).nonNull().forEach(elements::add);
                if (element instanceof PhpClass) {
                    PhpClass superclass2 = (PhpClass)element;
                    for (PhpNamedElement subclass : elements) {
                        buffer.append(PhpLineMarkerProvider.BREAK).append(PhpLineMarkerProvider.SPACE).append(PhpLineMarkerProvider.SPACE).append(PhpLineMarkerProvider.SPACE).append(PhpLineMarkerProvider.SPACE);
                        if (superclass2.isAbstract() && !((PhpClass)subclass).isAbstract()) {
                            buffer.append("implemented").append(PhpLineMarkerProvider.SPACE).append("by");
                        } else if (!superclass2.isTrait()) {
                            buffer.append("extended").append(PhpLineMarkerProvider.SPACE).append("by");
                        } else {
                            buffer.append("used").append(PhpLineMarkerProvider.SPACE).append("by");
                        }
                        buffer.append(PhpLineMarkerProvider.SPACE).append("'").append(subclass.getName()).append("'");
                    }
                } else if (element instanceof PhpClassMember && (superclass = ((PhpClassMember)element).getContainingClass()) != null) {
                    for (PhpNamedElement namedElement : elements) {
                        PhpClass subclass = ((PhpClassMember)namedElement).getContainingClass();
                        if (subclass == null) continue;
                        buffer.append(PhpLineMarkerProvider.BREAK).append(PhpLineMarkerProvider.SPACE).append(PhpLineMarkerProvider.SPACE).append(PhpLineMarkerProvider.SPACE).append(PhpLineMarkerProvider.SPACE);
                        if (superclass.isAbstract()) {
                            buffer.append("implemented").append(PhpLineMarkerProvider.SPACE).append("in").append(PhpLineMarkerProvider.SPACE).append("class");
                        } else {
                            buffer.append("overridden").append(PhpLineMarkerProvider.SPACE).append("in").append(PhpLineMarkerProvider.SPACE).append(subclass.isAbstract() ? "interface" : "class");
                        }
                        buffer.append(PhpLineMarkerProvider.SPACE).append("'").append(subclass.getName()).append("'");
                    }
                }
            } else if (element instanceof PhpClass) {
                buffer.append("Has").append(PhpLineMarkerProvider.SPACE);
                if (((PhpClass)element).isInterface()) {
                    buffer.append("implementations");
                } else {
                    buffer.append("subclasses");
                }
            } else if (element instanceof Method || element instanceof Field) {
                buffer.append("Has").append(PhpLineMarkerProvider.SPACE);
                if (element instanceof Method && ((Method)element).isAbstract()) {
                    buffer.append("implementations");
                } else {
                    buffer.append("overrides");
                }
            }
            return buffer.toString();
        }
    }
}

