/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.PhpCaches;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider2;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider3;
import com.jetbrains.php.lang.psi.stubs.PhpTypedStub;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class PhpTypeInfo {
    public static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.PhpTypeInfo");
    public static final boolean CACHE_TYPE_INFO = true;
    public static final RecursionGuard RECURSION_GUARD = RecursionManager.createGuard((String)"php.type.info");

    public static PhpType getType(@Nullable PsiElement psi) {
        StubElement stub;
        ProgressManager.checkCanceled();
        if (psi == null) {
            return PhpType.EMPTY;
        }
        Map<PsiElement, PhpType> type_cache = PhpCaches.getInstance((Project)psi.getProject()).TYPE_CACHE;
        PhpType type = type_cache.get(psi);
        if (type == null && psi instanceof StubBasedPsiElementBase && (stub = ((StubBasedPsiElementBase)psi).getGreenStub()) instanceof PhpTypedStub) {
            type = ((PhpTypedStub)stub).getType();
        }
        if (type == null) {
            RecursionGuard.StackStamp mark = RECURSION_GUARD.markStack();
            List currentStack = RECURSION_GUARD.currentStack();
            if (currentStack.size() > 100) {
                PsiElement top = (PsiElement)currentStack.get(0);
                LOG.warn("RECURSION LIMIT for " + top + " `" + top.getText() + "`:" + top.getTextOffset() + " on " + psi + " `" + StringUtil.trimLog((String)psi.getText(), (int)50) + "`:" + psi.getTextOffset() + "+" + psi.getTextLength() + " in " + PsiUtilCore.getVirtualFile((PsiElement)psi));
                RECURSION_GUARD.prohibitResultCaching((Object)psi);
            } else {
                type = (PhpType)RECURSION_GUARD.doPreventingRecursion((Object)psi, true, () -> {
                    PhpType providedTypes = new PhpType();
                    PhpTypeAnalyserVisitor typeAnalyser = new PhpTypeAnalyserVisitor();
                    psi.accept((PsiElementVisitor)typeAnalyser);
                    PhpType analysed = typeAnalyser.getType();
                    for (PhpTypeProvider3 provider : PhpTypeProvider3.EP_NAME.getExtensionList()) {
                        try {
                            ProgressManager.checkCanceled();
                            PhpType provided = provider.getType(psi);
                            if (provided != null && !provided.isEmpty() && LOG.isTraceEnabled()) {
                                LOG.trace("TypeProvider3 " + provider.getClass() + " +'" + provided + " @" + psi);
                            }
                            providedTypes.add(provided);
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            throw PluginManagerCore.createPluginException((String)("TypeProvider contract violation? by " + provider.getClass() + " on " + psi.getText()), (Throwable)e, provider.getClass());
                        }
                    }
                    if (!providedTypes.isEmpty()) {
                        return analysed.add(providedTypes);
                    }
                    for (PhpTypeProvider3 provider : PhpTypeProvider2.EP_NAME.getExtensionList()) {
                        ProgressManager.checkCanceled();
                        String providerType = provider.getType(psi);
                        if (providerType == null) continue;
                        StringUtil.split((String)providerType, (String)"|").stream().map(arg_0 -> PhpTypeInfo.lambda$null$0((PhpTypeProvider2)provider, arg_0)).forEach(arg_0 -> ((PhpType)providedTypes).add(arg_0));
                    }
                    if (!providedTypes.isEmpty()) {
                        return analysed.add(providedTypes);
                    }
                    return analysed;
                });
            }
            if (type == null) {
                type = PhpType.EMPTY;
            }
            if (type_cache.size() > 7000) {
                type_cache.clear();
            }
            if (mark.mayCacheNow()) {
                type_cache.put(psi, type);
            }
        }
        return type;
    }

    private static /* synthetic */ String lambda$null$0(PhpTypeProvider2 provider, String s) {
        return "#" + provider.getKey() + s;
    }
}

