/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.lang.PhpLangUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpNameUtil {
    public static final int HIGH_PRIORITY = 1;
    public static final int MEDIUM_PRIORITY = 2;
    public static final int LOW_PRIORITY = 3;

    private PhpNameUtil() {
    }

    @NotNull
    public static List<String> filterIdentifiers(@NotNull Collection<String> names) {
        if (names == null) {
            PhpNameUtil.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.filter(names, PhpLangUtil.PHP_IDENTIFIER_CONDITION);
        if (list == null) {
            PhpNameUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    public static boolean equals(@NotNull List<String> list1, @NotNull List<String> list2, boolean ignoreCase) {
        int cur2;
        if (list1 == null) {
            PhpNameUtil.$$$reportNull$$$0(2);
        }
        if (list2 == null) {
            PhpNameUtil.$$$reportNull$$$0(3);
        }
        int cur1 = 0;
        for (cur2 = 0; cur1 < list1.size() && cur2 < list2.size(); ++cur1, ++cur2) {
            if (ignoreCase && list1.get(cur1).equalsIgnoreCase(list2.get(cur2)) || !ignoreCase && list1.get(cur1).equals(list2.get(cur2))) {
                continue;
            }
            return false;
        }
        return cur1 == list1.size() && cur2 == list2.size();
    }

    @NotNull
    public static List<String> splitName(@NotNull String name) {
        if (name == null) {
            PhpNameUtil.$$$reportNull$$$0(4);
        }
        List<String> list = Arrays.asList(NameUtil.nameToWords((String)name));
        if (list == null) {
            PhpNameUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static String concatenateNames(@NotNull String name1, @NotNull String name2) {
        if (name1 == null) {
            PhpNameUtil.$$$reportNull$$$0(6);
        }
        if (name2 == null) {
            PhpNameUtil.$$$reportNull$$$0(7);
        }
        if (name1.length() == 0) {
            String string = name2;
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (name2.length() == 0) {
            String string = name1;
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        char lastCharInName1 = name1.charAt(name1.length() - 1);
        char firstCharInName2 = name2.charAt(0);
        if (Character.isDigit(lastCharInName1) && Character.isDigit(firstCharInName2)) {
            String string = name1 + "_" + name2;
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (Character.isUpperCase(lastCharInName1) && Character.isUpperCase(firstCharInName2)) {
            if (PhpNameUtil.isUppedCased(name2)) {
                String string = name1 + "_" + name2;
                if (string == null) {
                    PhpNameUtil.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = name1 + name2;
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (Character.isLowerCase(lastCharInName1) && Character.isLowerCase(firstCharInName2)) {
            String string = name1 + StringUtil.capitalize((String)name2);
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = name1 + name2;
        if (string == null) {
            PhpNameUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    public static boolean isUppedCased(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(15);
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void unique(List<String> names, Set<String> occupiedNames) {
        THashSet alreadyAddedNames = new THashSet();
        for (int i = 0; i < names.size(); ++i) {
            String suggestedName = names.get(i);
            if (!occupiedNames.contains(suggestedName)) continue;
            int numericSuffix = 1;
            String nameBase = suggestedName + numericSuffix;
            while (occupiedNames.contains(nameBase)) {
                nameBase = suggestedName + ++numericSuffix;
            }
            if (alreadyAddedNames.contains(nameBase)) continue;
            alreadyAddedNames.add(nameBase);
            names.set(i, nameBase);
        }
    }

    @NotNull
    public static String unique(@NotNull String suggestedName, @NotNull String prefix, @NotNull String suffix, Condition<? super String> isOccupied) {
        if (suggestedName == null) {
            PhpNameUtil.$$$reportNull$$$0(16);
        }
        if (prefix == null) {
            PhpNameUtil.$$$reportNull$$$0(17);
        }
        if (suffix == null) {
            PhpNameUtil.$$$reportNull$$$0(18);
        }
        if (isOccupied.value((Object)suggestedName)) {
            int numericSuffix = 1;
            String nameBase = suggestedName + prefix + numericSuffix + suffix;
            while (isOccupied.value((Object)nameBase)) {
                nameBase = suggestedName + prefix + ++numericSuffix + suffix;
            }
            String string = nameBase;
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = suggestedName;
        if (string == null) {
            PhpNameUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String getFullFileName(@NotNull String fileName, @NotNull String extension) {
        if (fileName == null) {
            PhpNameUtil.$$$reportNull$$$0(21);
        }
        if (extension == null) {
            PhpNameUtil.$$$reportNull$$$0(22);
        }
        String string = fileName + "." + extension;
        if (string == null) {
            PhpNameUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static boolean isValidNameIdentifier(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(24);
        }
        return PhpLangUtil.isPhpIdentifier(str) && !PhpLangUtil.isPhpReservedKeyword(str);
    }

    public static boolean isValidVariableName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(25);
        }
        return PhpLangUtil.isPhpIdentifier(str);
    }

    public static boolean isValidClassName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(26);
        }
        return PhpNameUtil.isValidNameIdentifier(str) && !PhpLangUtil.isPhpReservedClassName(str);
    }

    public static boolean isValidClassConstantName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(27);
        }
        return PhpLangUtil.isPhpIdentifier(str);
    }

    public static boolean isValidConstantName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(28);
        }
        return PhpNameUtil.isValidNameIdentifier(str);
    }

    public static boolean isValidFieldName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(29);
        }
        return PhpLangUtil.isPhpIdentifier(str) && !PhpLangUtil.isPhpReservedFieldName(str);
    }

    public static boolean isValidFunctionName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(30);
        }
        return PhpNameUtil.isValidNameIdentifier(str);
    }

    public static boolean isValidMethodName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(31);
        }
        return PhpLangUtil.isPhpIdentifier(str);
    }

    public static boolean isValidParameterName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(32);
        }
        return !PhpLangUtil.isThisReference(str) && PhpNameUtil.isValidVariableName(str);
    }

    public static boolean isValidNamespaceName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(33);
        }
        return PhpNameUtil.isValidNameIdentifier(str);
    }

    public static boolean isValidGotoLabelName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(34);
        }
        return PhpNameUtil.isValidNameIdentifier(str);
    }

    public static boolean isValidNamespaceFullName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(35);
        }
        return PhpNameUtil.isValidNamespaceFullName(str, false);
    }

    public static boolean isValidNamespaceFullName(@NotNull String str, boolean allowFullyQualified) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(36);
        }
        if (StringUtil.isEmpty((String)str)) {
            return false;
        }
        for (String s : StringUtil.split((String)str, (String)"\\", (boolean)true, (boolean)allowFullyQualified)) {
            if (PhpNameUtil.isValidNamespaceName(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFileName(@NotNull String fileName) {
        if (fileName == null) {
            PhpNameUtil.$$$reportNull$$$0(37);
        }
        return fileName.length() != 0 && fileName.indexOf(47) < 0 && fileName.indexOf(92) < 0;
    }

    public static boolean isPhpIdentifierInDoubleQuotes(@NotNull String identifier) {
        if (identifier == null) {
            PhpNameUtil.$$$reportNull$$$0(38);
        }
        return identifier.length() > 1 && identifier.startsWith("\"") && identifier.endsWith("\"") && PhpLangUtil.isPhpIdentifier(identifier.substring(1, identifier.length() - 1));
    }

    public static boolean isValidHeredocIdentifier(@NotNull String heredocIdentifier, boolean isHereDoc) {
        if (heredocIdentifier == null) {
            PhpNameUtil.$$$reportNull$$$0(39);
        }
        return PhpLangUtil.isPhpIdentifier(heredocIdentifier) || PhpNameUtil.isPhpIdentifierInDoubleQuotes(heredocIdentifier) && isHereDoc;
    }

    @NotNull
    public static String trimEnd(@NotNull String str, char ... chars) {
        int i;
        int length;
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(40);
        }
        if ((length = str.length()) == 0) {
            String string = str;
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(41);
            }
            return string;
        }
        char[] value = str.toCharArray();
        block0: for (i = value.length - 1; i > -1; --i) {
            for (char curChar : chars) {
                if (value[i] != curChar) continue;
                continue block0;
            }
        }
        char[] newValue = new char[i + 1];
        System.arraycopy(value, 0, newValue, 0, i + 1);
        String string = new String(newValue);
        if (string == null) {
            PhpNameUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    public static String trimStart(@NotNull String str, char ... chars) {
        int i;
        int length;
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(43);
        }
        if ((length = str.length()) == 0) {
            String string = str;
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(44);
            }
            return string;
        }
        char[] value = str.toCharArray();
        block0: for (i = 0; i < value.length; ++i) {
            for (char curChar : chars) {
                if (value[i] != curChar) continue;
                continue block0;
            }
        }
        char[] newValue = new char[value.length - i];
        System.arraycopy(value, i, newValue, 0, value.length - i);
        String string = new String(newValue);
        if (string == null) {
            PhpNameUtil.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public static String trim(@NotNull String str, char ... chars) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(46);
        }
        String string = PhpNameUtil.trimStart(PhpNameUtil.trimEnd(str, chars), chars);
        if (string == null) {
            PhpNameUtil.$$$reportNull$$$0(47);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public static String unquote(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(48);
        }
        String string = StringUtil.unquoteString((String)str);
        if (string == null) {
            PhpNameUtil.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    public static String getExtension(@NotNull String fileName) {
        int lastIndex;
        if (fileName == null) {
            PhpNameUtil.$$$reportNull$$$0(50);
        }
        if ((lastIndex = fileName.lastIndexOf(46)) > -1) {
            String string = fileName.substring(lastIndex + 1);
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(51);
            }
            return string;
        }
        if ("" == null) {
            PhpNameUtil.$$$reportNull$$$0(52);
        }
        return "";
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String fileName) {
        int lastIndex;
        if (fileName == null) {
            PhpNameUtil.$$$reportNull$$$0(53);
        }
        if ((lastIndex = fileName.lastIndexOf(46)) > -1) {
            String string = fileName.substring(0, lastIndex);
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(54);
            }
            return string;
        }
        String string = fileName;
        if (string == null) {
            PhpNameUtil.$$$reportNull$$$0(55);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpNameUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 15: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 43: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 21: 
            case 37: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heredocIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpNameUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "filterIdentifiers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "splitName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "concatenateNames";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "unique";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullFileName";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "trim";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "unquote";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterIdentifiers";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "splitName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "concatenateNames";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isUppedCased";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unique";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFullFileName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isValidNameIdentifier";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isValidVariableName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isValidClassName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isValidClassConstantName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isValidConstantName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isValidFieldName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isValidFunctionName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isValidMethodName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isValidParameterName";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isValidNamespaceName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isValidGotoLabelName";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isValidNamespaceFullName";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isValidFileName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isPhpIdentifierInDoubleQuotes";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isValidHeredocIdentifier";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "unquote";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NameSuggestionsManager {
        private final MultiMap<Integer, String> myNamesMap = new MultiMap();
        private final Set<String> myNamesSet = new THashSet();

        public void add(String name, int priority) {
            if (!this.myNamesSet.contains(name)) {
                this.myNamesSet.add(name);
                this.myNamesMap.putValue((Object)priority, (Object)name);
            }
        }

        public void add(List<String> names, int priority) {
            for (String name : names) {
                this.add(name, priority);
            }
        }

        public List<String> getSuggestions() {
            Set prioritySet = this.myNamesMap.keySet();
            Object[] priorities = prioritySet.toArray(new Integer[0]);
            Arrays.sort(priorities);
            ArrayList<String> suggestedNames = new ArrayList<String>();
            Object[] objectArray = priorities;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                int priority = (Integer)objectArray[i];
                suggestedNames.addAll(this.myNamesMap.get((Object)priority));
            }
            return suggestedNames;
        }
    }
}

