/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.inplace;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.inplace.PhpConstantInFileIntroducePanel;
import com.jetbrains.php.refactoring.introduce.inplace.PhpConstantInplaceIntroduceFacade;
import com.jetbrains.php.refactoring.introduce.inplace.PhpInplaceVariableIntroducer;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantHandler;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInplaceConstantInFileIntroducer
extends PhpInplaceVariableIntroducer {
    private static final String LAST_SELECTED_VISIBILITY = PhpInplaceConstantInFileIntroducer.class.getName() + ".lastSelectedSyntax";
    @Nullable
    private final PhpConstantInFileIntroducePanel myPanel;
    private final boolean myDefineSyntax;
    private final PhpIntroduceContext myContext;

    public PhpInplaceConstantInFileIntroducer(PhpIntroduceContext context, PsiNamedElement element, boolean defineSyntax) {
        super(element, context, "Introduce constant");
        this.myContext = context;
        this.myPanel = PhpConstantInFileIntroducePanel.canBeShown(context) ? new PhpConstantInFileIntroducePanel(this.myProject, defineSyntax) : null;
        this.myDefineSyntax = defineSyntax;
    }

    @Nullable
    protected JComponent getComponent() {
        return this.myPanel != null ? this.myPanel.getRootPanel() : null;
    }

    @Override
    protected void adjustCaret(PsiElement elementToSelect) {
    }

    public static boolean lastSelectedSyntaxIsDefine(@NotNull Project project) {
        if (project == null) {
            PhpInplaceConstantInFileIntroducer.$$$reportNull$$$0(0);
        }
        return PropertiesComponent.getInstance((Project)project).isValueSet(LAST_SELECTED_VISIBILITY);
    }

    protected void moveOffsetAfter(boolean success) {
        boolean defineSyntax;
        if (success && this.myPanel != null && (defineSyntax = this.myPanel.isDefineSyntax()) != this.myDefineSyntax) {
            PhpNamedElement constant = PhpConstantInplaceIntroduceFacade.resolveConstantReferenceAtCaret(this.myContext, false);
            Object constantWrapper = PhpPsiUtil.getParentByCondition((PsiElement)constant, (Condition<? super PsiElement>)((Condition)c -> PhpPsiUtil.isOfType(c, this.myDefineSyntax ? PhpElementTypes.STATEMENT : PhpElementTypes.CONSTANTS)));
            if (constantWrapper != null) {
                WriteAction.run(() -> constantWrapper.replace(PhpIntroduceConstantHandler.createFileConstantDeclaration(this.myContext, defineSyntax, constant.getName())));
            }
            PropertiesComponent.getInstance((Project)this.myProject).setValue(LAST_SELECTED_VISIBILITY, defineSyntax);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/refactoring/introduce/inplace/PhpInplaceConstantInFileIntroducer", "lastSelectedSyntaxIsDefine"));
    }
}

