/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceConstant;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseDialog;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBasePresenter;
import com.jetbrains.php.refactoring.introduce.introduceConstant.PhpIntroduceConstantDisplay;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIntroduceConstantDialog
extends PhpIntroduceBaseDialog
implements PhpIntroduceConstantDisplay {
    private JPanel myCenterPanel;
    private JPanel myFileScopePanel;
    private JRadioButton myDefineRadioButton;
    private JRadioButton myConstRadioButton;
    private JPanel myVisibilityPanel;
    private JRadioButton myPublicRadioButton;
    private JRadioButton myProtectedRadioButton;
    private JRadioButton myPrivateRadioButton;
    private JRadioButton myDefaultRadioButton;
    @Nullable
    private PsiElement myScope;
    private ActionListener myVisibilityChangedListener;

    public PhpIntroduceConstantDialog(Project project) {
        super(project);
        this.$$$setupUI$$$();
        this.myFileScopePanel.setVisible(false);
        this.myVisibilityPanel.setVisible(false);
    }

    @Override
    protected String getHelpId() {
        return "refactoring.introduceConstant";
    }

    @Override
    public String getTitle() {
        return PhpBundle.message("refactoring.extract.constant.name", new Object[0]);
    }

    @NotNull
    protected JPanel createCenterPanel() {
        JPanel jPanel = this.myCenterPanel;
        if (jPanel == null) {
            PhpIntroduceConstantDialog.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @Override
    protected boolean isReplaceAllOccurrencesByDefault() {
        return true;
    }

    @Override
    public void setData(int expressionOccurrences, @NotNull String[] suggestedNames, @NotNull PhpIntroduceBasePresenter.DisplayHandler handler, @Nullable PsiElement scope, boolean allowConstSyntax) {
        PhpLanguageLevel languageLevel;
        if (suggestedNames == null) {
            PhpIntroduceConstantDialog.$$$reportNull$$$0(1);
        }
        if (handler == null) {
            PhpIntroduceConstantDialog.$$$reportNull$$$0(2);
        }
        this.myScope = scope;
        super.setData(expressionOccurrences, suggestedNames, handler);
        if (scope instanceof PhpFile) {
            this.myFileScopePanel.setVisible(true);
            if (allowConstSyntax) {
                this.myConstRadioButton.setSelected(true);
            } else {
                this.myConstRadioButton.setEnabled(false);
                this.myDefineRadioButton.setSelected(true);
            }
        } else if (scope instanceof PhpClass && (languageLevel = PhpProjectConfigurationFacade.getInstance(this.myProject).getLanguageLevel()).hasFeature(PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY)) {
            this.myVisibilityPanel.setVisible(true);
            this.myDefaultRadioButton.setSelected(true);
            if (((PhpClass)ObjectUtils.tryCast((Object)scope, PhpClass.class)).isInterface()) {
                this.myPrivateRadioButton.setVisible(false);
                this.myProtectedRadioButton.setVisible(false);
            }
        }
        this.init();
    }

    @Override
    @Nullable
    public PsiElement getScope() {
        return this.myScope;
    }

    @Override
    @Nullable
    public PhpModifier.Access getAccess() {
        if (this.myPublicRadioButton.isSelected()) {
            return PhpModifier.Access.PUBLIC;
        }
        if (this.myProtectedRadioButton.isSelected()) {
            return PhpModifier.Access.PROTECTED;
        }
        if (this.myPrivateRadioButton.isSelected()) {
            return PhpModifier.Access.PRIVATE;
        }
        return null;
    }

    @Override
    public boolean isDefineSyntax() {
        return this.myDefineRadioButton.isSelected();
    }

    @Override
    protected void init() {
        super.init();
        this.myVisibilityChangedListener = e -> this.scheduleValidation();
        this.myPublicRadioButton.addActionListener(this.myVisibilityChangedListener);
        this.myProtectedRadioButton.addActionListener(this.myVisibilityChangedListener);
        this.myPrivateRadioButton.addActionListener(this.myVisibilityChangedListener);
        this.myDefaultRadioButton.addActionListener(this.myVisibilityChangedListener);
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.myPublicRadioButton.removeActionListener(this.myVisibilityChangedListener);
        this.myProtectedRadioButton.removeActionListener(this.myVisibilityChangedListener);
        this.myPrivateRadioButton.removeActionListener(this.myVisibilityChangedListener);
        this.myDefaultRadioButton.removeActionListener(this.myVisibilityChangedListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/introduceConstant/PhpIntroduceConstantDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedNames";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/introduceConstant/PhpIntroduceConstantDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myCenterPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myFileScopePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Constant syntax", (int)0, (int)0, null, null));
        this.myDefineRadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("define");
        jRadioButton6.setMnemonic('D');
        jRadioButton6.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myConstRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("const");
        jRadioButton5.setMnemonic('C');
        jRadioButton5.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myVisibilityPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Visibility", (int)0, (int)0, null, null));
        this.myPublicRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("public");
        jRadioButton4.setMnemonic('U');
        jRadioButton4.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jRadioButton4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myProtectedRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("protected");
        jRadioButton3.setMnemonic('O');
        jRadioButton3.setDisplayedMnemonicIndex(2);
        jPanel.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPrivateRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("private");
        jRadioButton2.setMnemonic('I');
        jRadioButton2.setDisplayedMnemonicIndex(2);
        jPanel.add((Component)jRadioButton2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDefaultRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("default");
        jRadioButton.setMnemonic('F');
        jRadioButton.setDisplayedMnemonicIndex(2);
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton6);
        buttonGroup.add(jRadioButton6);
        buttonGroup.add(jRadioButton5);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myCenterPanel;
    }
}

