/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Device
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="CgroupPermissions")
    private String cGroupPermissions = "";
    @JsonProperty(value="PathOnHost")
    private String pathOnHost = null;
    @JsonProperty(value="PathInContainer")
    private String pathInContainer = null;

    public Device() {
    }

    public Device(String cGroupPermissions, String pathInContainer, String pathOnHost) {
        Preconditions.checkNotNull((Object)cGroupPermissions, (Object)"cGroupPermissions is null");
        Preconditions.checkNotNull((Object)pathInContainer, (Object)"pathInContainer is null");
        Preconditions.checkNotNull((Object)pathOnHost, (Object)"pathOnHost is null");
        this.cGroupPermissions = cGroupPermissions;
        this.pathInContainer = pathInContainer;
        this.pathOnHost = pathOnHost;
    }

    public String getcGroupPermissions() {
        return this.cGroupPermissions;
    }

    public String getPathInContainer() {
        return this.pathInContainer;
    }

    public String getPathOnHost() {
        return this.pathOnHost;
    }

    @Nonnull
    public static Device parse(@Nonnull String deviceStr) {
        String src = "";
        String dst = "";
        String permissions = "rwm";
        String[] arr = deviceStr.trim().split(":");
        switch (new StringTokenizer(deviceStr, ":").countTokens()) {
            case 3: {
                if (Device.validDeviceMode(arr[2])) {
                    permissions = arr[2];
                } else {
                    throw new IllegalArgumentException("Invalid device specification: " + deviceStr);
                }
            }
            case 2: {
                if (Device.validDeviceMode(arr[1])) {
                    permissions = arr[1];
                } else {
                    dst = arr[1];
                }
            }
            case 1: {
                src = arr[0];
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid device specification: " + deviceStr);
            }
        }
        if (StringUtils.isEmpty((String)dst)) {
            dst = src;
        }
        return new Device(permissions, dst, src);
    }

    private static boolean validDeviceMode(String deviceMode) {
        HashMap<String, Boolean> validModes = new HashMap<String, Boolean>(3);
        validModes.put("r", true);
        validModes.put("w", true);
        validModes.put("m", true);
        if (StringUtils.isEmpty((String)deviceMode)) {
            return false;
        }
        for (char ch : deviceMode.toCharArray()) {
            String mode = String.valueOf(ch);
            if (BooleanUtils.isNotTrue((Boolean)((Boolean)validModes.get(mode)))) {
                return false;
            }
            validModes.put(mode, false);
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Device) {
            Device other = (Device)obj;
            return new EqualsBuilder().append((Object)this.cGroupPermissions, (Object)other.getcGroupPermissions()).append((Object)this.pathInContainer, (Object)other.getPathInContainer()).append((Object)this.pathOnHost, (Object)other.getPathOnHost()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.cGroupPermissions).append((Object)this.pathInContainer).append((Object)this.pathOnHost).toHashCode();
    }
}

