/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.diff;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.run.profile.TreeTableWidthController;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.calculation.CallTreeType;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.DiffNode;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.V8CpuDiffTableModel;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.view.ProfilingView;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeComponent;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8CpuDiffComponent
implements ProfilingView<V8ProfilingCallTreeTable> {
    private String myErrorText;
    @NotNull
    private final Project myProject;
    @Nullable
    private final DiffNode myRoot;
    @NotNull
    private final CallTreeType myCallTreeType;
    private final Disposable myDisposable;
    @NotNull
    private final V8LogCachingReader myBaseReader;
    @NotNull
    private final V8LogCachingReader myChangedReader;
    private JComponent myMainPane;
    private V8ProfilingCallTreeTable myTable;

    public V8CpuDiffComponent(@NotNull Project project, @Nullable DiffNode root, @NotNull CallTreeType callTreeType, Disposable disposable, @NotNull V8LogCachingReader baseReader, @NotNull V8LogCachingReader changedReader) {
        if (project == null) {
            V8CpuDiffComponent.$$$reportNull$$$0(0);
        }
        if (callTreeType == null) {
            V8CpuDiffComponent.$$$reportNull$$$0(1);
        }
        if (baseReader == null) {
            V8CpuDiffComponent.$$$reportNull$$$0(2);
        }
        if (changedReader == null) {
            V8CpuDiffComponent.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myRoot = root;
        this.myCallTreeType = callTreeType;
        this.myDisposable = disposable;
        this.myBaseReader = baseReader;
        this.myChangedReader = changedReader;
        this.createMainComponent();
    }

    private void createMainComponent() {
        V8CpuDiffTableModel model = new V8CpuDiffTableModel(this.myRoot, this.myCallTreeType, (int)this.myBaseReader.getNumTicks(), (int)this.myChangedReader.getNumTicks());
        this.myTable = new V8ProfilingCallTreeTable(this.myProject, model, this.myDisposable);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.myTable.setRootVisible(false);
        this.myTable.getTree().setShowsRootHandles(true);
        this.myTable.getTree().setLineStyleAngled();
        V8Utils.adjustColumnWIdths(this.myTable, null);
        new TreeTableSpeedSearch((TreeTable)this.myTable, path -> {
            Object o = path.getLastPathComponent();
            if (o instanceof V8ProfileLine) {
                return ((V8ProfileLine)o).getFileDescriptor() != null ? ((V8ProfileLine)o).getFileDescriptor().getShortLink() : ((V8ProfileLine)o).getNotParsedCallable();
            }
            return o.toString();
        });
        TreeTableWidthController controller = new TreeTableWidthController(this.myTable, this.myDisposable);
        controller.setMeaningfulRenderer(model.getRenderer());
        this.myTable.setController(controller);
        this.myMainPane = new JBScrollPane((Component)((Object)this.myTable));
    }

    @Override
    public JComponent getMainComponent() {
        return this.myMainPane;
    }

    @Override
    public String getName() {
        return CallTreeType.topDown.equals((Object)this.myCallTreeType) ? "Top-down Diff" : "Bottom-up Diff";
    }

    @Override
    public void addActions(DefaultActionGroup group) {
        group.add((AnAction)new V8Utils.LightweightEditSourceAction((JComponent)((Object)this.myTable)));
        String filterName = CallTreeType.topDown.equals((Object)this.myCallTreeType) ? "Total % Filter" : "Parent % Filter";
        group.add((AnAction)V8ProfilingCallTreeComponent.createFilterAction(this.myTable, filterName, () -> this.defaultExpand(), () -> this.myTable.getWidthController().recalculateAll()));
    }

    @Override
    public String getError() {
        return null;
    }

    @Override
    @Nullable
    public V8ProfilingCallTreeTable getTreeTable() {
        return this.myTable;
    }

    @Override
    public void defaultExpand() {
        new V8ProfilingCallTreeComponent.ConditionalExpander(this.myTable){
            private final Consumer<TreePath> mostInterestingSelector;
            private int myCurrentTotal;
            private int myCurrentSelf;
            {
                this.mostInterestingSelector = CallTreeType.topDown.equals((Object)V8CpuDiffComponent.this.myCallTreeType) ? new Consumer<TreePath>(){
                    int biggestSelfPercent = 0;

                    public void consume(TreePath path) {
                        if (myCurrentSelf > this.biggestSelfPercent) {
                            myPathToSelect = path;
                            this.biggestSelfPercent = myCurrentSelf;
                        }
                    }
                } : new Consumer<TreePath>(){
                    int ticks = 0;

                    public void consume(TreePath path) {
                        if (path.getPathCount() == 2 && myCurrentTotal > this.ticks) {
                            myPathToSelect = path;
                            this.ticks = myCurrentTotal;
                        }
                    }
                };
            }

            @Override
            protected boolean toExpand(TreePath path) {
                Object o = path.getLastPathComponent();
                if (o instanceof DiffNode) {
                    DiffNode line = (DiffNode)o;
                    this.myCurrentTotal = 0;
                    this.myCurrentSelf = 0;
                    if (line.getBefore() != null) {
                        this.onTicks(line.getBefore(), true);
                    }
                    if (line.getAfter() != null) {
                        this.onTicks(line.getAfter(), false);
                    }
                    if (this.myCurrentTotal >= 100 || this.myCurrentSelf >= 100) {
                        this.mostInterestingSelector.consume((Object)path);
                        return true;
                    }
                }
                return false;
            }

            private void onTicks(DiffNode.Ticks line, boolean isBefore) {
                this.myCurrentTotal = Math.max(this.myCurrentTotal, ((V8CpuDiffTableModel)this.myTable.getTableModel()).tensPercent(line, isBefore));
                this.myCurrentSelf = Math.max(this.myCurrentSelf, CallTreeType.topDown.equals((Object)V8CpuDiffComponent.this.myCallTreeType) ? V8Utils.tensPercent(line.getSelf(), isBefore ? (int)V8CpuDiffComponent.this.myBaseReader.getNumTicks() : (int)V8CpuDiffComponent.this.myChangedReader.getNumTicks()) : 0);
            }
        }.execute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "callTreeType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "baseReader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "changedReader";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/diff/V8CpuDiffComponent";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

