/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.InjectionAssertionData;
import com.intellij.testFramework.fixtures.InjectionTestFixture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00010!J\u0018\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00160$0#R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lcom/intellij/testFramework/fixtures/InjectionTestFixture;", "", "javaFixture", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;)V", "injectedElement", "Lcom/intellij/psi/PsiElement;", "getInjectedElement", "()Lcom/intellij/psi/PsiElement;", "injectedLanguageManager", "Lcom/intellij/lang/injection/InjectedLanguageManager;", "getInjectedLanguageManager", "()Lcom/intellij/lang/injection/InjectedLanguageManager;", "topLevelCaretPosition", "", "getTopLevelCaretPosition", "()I", "topLevelEditor", "Lcom/intellij/openapi/editor/Editor;", "getTopLevelEditor", "()Lcom/intellij/openapi/editor/Editor;", "topLevelFile", "Lcom/intellij/psi/PsiFile;", "getTopLevelFile", "()Lcom/intellij/psi/PsiFile;", "assertInjected", "", "expectedInjections", "", "Lcom/intellij/testFramework/fixtures/InjectionAssertionData;", "([Lcom/intellij/testFramework/fixtures/InjectionAssertionData;)V", "assertInjectedLangAtCaret", "lang", "", "getAllInjections", "", "Lkotlin/Pair;", "intellij.platform.testFramework"})
public final class InjectionTestFixture {
    private final CodeInsightTestFixture javaFixture;

    @NotNull
    public final InjectedLanguageManager getInjectedLanguageManager() {
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)this.javaFixture.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)injectedLanguageManager, (String)"InjectedLanguageManager.\u2026ance(javaFixture.project)");
        return injectedLanguageManager;
    }

    @Nullable
    public final PsiElement getInjectedElement() {
        return this.getInjectedLanguageManager().findInjectedElementAt(this.getTopLevelFile(), this.getTopLevelCaretPosition());
    }

    public final void assertInjectedLangAtCaret(@Nullable String lang) {
        PsiElement injectedElement = this.getInjectedElement();
        if (lang != null) {
            TestCase.assertNotNull((String)("injection of '" + lang + "' expected"), (Object)injectedElement);
            PsiElement psiElement = injectedElement;
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
            Language language = psiElement.getLanguage();
            Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"injectedElement!!.language");
            TestCase.assertEquals((String)lang, (String)language.getID());
        } else {
            TestCase.assertNull((Object)injectedElement);
        }
    }

    @NotNull
    public final List<Pair<PsiElement, PsiFile>> getAllInjections() {
        List injected = new ArrayList();
        Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)((PsiElement)this.getTopLevelFile()), (Class[])new Class[]{PsiLanguageInjectionHost.class});
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"PsiTreeUtil.collectEleme\u2026njectionHost::class.java)");
        Collection hosts = collection;
        for (PsiLanguageInjectionHost host : hosts) {
            this.getInjectedLanguageManager().enumerate((PsiElement)host, new PsiLanguageInjectionHost.InjectedPsiVisitor(injected, host){
                final /* synthetic */ List $injected;
                final /* synthetic */ PsiLanguageInjectionHost $host;

                public final void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                    Intrinsics.checkParameterIsNotNull((Object)injectedPsi, (String)"injectedPsi");
                    Intrinsics.checkParameterIsNotNull(places, (String)"places");
                    this.$injected.add(TuplesKt.to((Object)this.$host, (Object)injectedPsi));
                }
                {
                    this.$injected = list;
                    this.$host = psiLanguageInjectionHost;
                }
            });
        }
        return injected;
    }

    /*
     * Unable to fully structure code
     */
    public final void assertInjected(InjectionAssertionData ... expectedInjections) {
        Intrinsics.checkParameterIsNotNull((Object)expectedInjections, (String)"expectedInjections");
        expected = (LinkedList)ArraysKt.toCollection((Object[])expectedInjections, (Collection)new LinkedList<E>());
        foundInjections = (LinkedList)CollectionsKt.toCollection((Iterable)this.getAllInjections(), (Collection)new LinkedList<E>());
        while ((var4_4 = (Collection)expected).isEmpty() == false) {
            block5: {
                var6_6 = (InjectionAssertionData)expected.pop();
                var4_4 = var6_6.component1();
                injectedLanguage = var6_6.component2();
                var8_8 = var7_7 = (Iterable)foundInjections;
                for (T var10_10 : var8_8) {
                    $psi_file = (Pair)var10_10;
                    psi = (PsiElement)$psi_file.component1();
                    file = (PsiFile)$psi_file.component2();
                    if (!Intrinsics.areEqual((Object)psi.getText(), (Object)text)) ** GOTO lbl-1000
                    v0 = file.getLanguage();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"file.language");
                    if (Intrinsics.areEqual((Object)v0.getID(), (Object)injectedLanguage)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v2 = var10_10;
                    break block5;
                }
                v2 = null;
            }
            if ((Pair)v2 == null) {
                v3 = AssertionsKt.fail((String)("no injection '" + (String)text + "' -> '" + injectedLanguage + "' were found, remains: " + CollectionsKt.joinToString$default((Iterable)foundInjections, null, null, null, (int)0, null, (Function1)assertInjected.found.2.INSTANCE, (int)31, null) + "   "));
                throw null;
            }
            foundInjections.remove(found);
        }
    }

    @NotNull
    public final PsiFile getTopLevelFile() {
        PsiFile psiFile;
        PsiFile it = psiFile = this.javaFixture.getFile();
        PsiFile psiFile2 = this.getInjectedLanguageManager().getTopLevelFile((PsiElement)it);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"injectedLanguageManager.getTopLevelFile(it)");
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"javaFixture.file.let { i\u2026ger.getTopLevelFile(it) }");
        return psiFile2;
    }

    public final int getTopLevelCaretPosition() {
        CaretModel caretModel = this.getTopLevelEditor().getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"topLevelEditor.caretModel");
        return caretModel.getOffset();
    }

    @NotNull
    public final Editor getTopLevelEditor() {
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.javaFixture.getProject()).getSelectedEditor(this.getTopLevelFile().getVirtualFile());
        if (fileEditor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"(FileEditorManager.getIn\u2026le) as TextEditor).editor");
        return editor;
    }

    public InjectionTestFixture(@NotNull CodeInsightTestFixture javaFixture) {
        Intrinsics.checkParameterIsNotNull((Object)javaFixture, (String)"javaFixture");
        this.javaFixture = javaFixture;
    }
}

