// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.elements;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.jetbrains.php.lang.psi.stubs.PhpUseStub;
import org.jetbrains.annotations.Nullable;

/**
 * This is actually named element reference and alias at the same time.
 * Name is alias.
 */
public interface PhpUse extends PhpNamedElement, StubBasedPsiElement<PhpUseStub> {

  PhpUse[] EMPTY_ARRAY = new PhpUse[0];

  @Nullable
  PhpReference getTargetReference();

  @Nullable
  String getAliasName();

  boolean isTraitImport();

  boolean isOfConst();
  
  boolean isOfFunction();

  Condition<PsiElement> INSTANCEOF = use -> use instanceof PhpUse;
}
