/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.database;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseDataSetTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.MetaDataDecoratorDataSet;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class MetaDataTab
extends BaseDataSetTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MetaDataTab.class);

    @Override
    public String getTitle() {
        return s_stringMgr.getString("MetaDataTab.title");
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("MetaDataTab.hint");
    }

    @Override
    protected IDataSet createDataSet() throws DataSetException {
        ISQLConnection conn = this.getSession().getSQLConnection();
        try {
            DatabaseMetaData md = conn.getSQLMetaData().getJDBCMetaData();
            return new MetaDataDecoratorDataSet(md, this.getSession().getDriver().getDriverClassName(), this.getSession().getDriver().getJarFileNames());
        }
        catch (SQLException ex) {
            throw new DataSetException(ex);
        }
    }
}

