/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class StringManager {
    private static ILogger s_log = LoggerController.createLogger(StringManager.class);
    private ResourceBundle _rsrcBundle;
    private String _bundleBaseName;
    private URL[] _bundleLoaderUrLs = new URL[0];
    private static boolean _testMode = false;

    StringManager(String packageName, ClassLoader loader) {
        this._bundleBaseName = packageName + ".I18NStrings";
        this._rsrcBundle = ResourceBundle.getBundle(this._bundleBaseName, Locale.getDefault(), loader);
        if (loader instanceof URLClassLoader) {
            this._bundleLoaderUrLs = ((URLClassLoader)loader).getURLs();
        }
    }

    public String getString(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        try {
            return this._rsrcBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            StringBuilder sb = new StringBuilder();
            sb.append("No resource string found for key '" + key + "' in bundle " + this._bundleBaseName + "\n\n");
            if (0 < this._bundleLoaderUrLs.length) {
                sb.append("The following classpath entries are available to the bundle loader:\n");
                for (int i = 0; i < this._bundleLoaderUrLs.length; ++i) {
                    sb.append(this._bundleLoaderUrLs[i]).append("\n");
                }
            }
            s_log.error(sb.toString(), ex);
            if (_testMode) {
                throw new IllegalStateException(sb.toString());
            }
            return "No resource found for key " + key;
        }
    }

    public String getString(String key, String[] args) {
        return this.getString(key, (Object[])args);
    }

    public String getString(String key, Object ... args) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (args == null) {
            args = new Object[]{};
        }
        String str = this.getString(key);
        try {
            return MessageFormat.format(str, args);
        }
        catch (IllegalArgumentException ex) {
            String msg = "Error formatting i18 string. Key is '" + key + "'";
            s_log.error(msg, ex);
            return msg + ": " + ex.toString();
        }
    }

    public static void setTestMode(boolean enabled) {
        _testMode = enabled;
    }
}

