/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.components;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.graalvm.visualvm.lib.ui.UIUtils;

public class JExtendedRadioButton
extends JRadioButton {
    private Icon extraIcon;

    public JExtendedRadioButton(Icon extraIcon) {
        this.setExtraIcon(extraIcon);
    }

    public JExtendedRadioButton(String text) {
        super(text);
    }

    public JExtendedRadioButton(String text, Icon extraIcon) {
        this(text);
        this.setExtraIcon(extraIcon);
    }

    public void setExtraIcon(Icon extraIcon) {
        if (!JExtendedRadioButton.isSupportedLaF()) {
            return;
        }
        this.extraIcon = extraIcon;
        if (extraIcon != null) {
            this.createExtraIcon();
        } else {
            this.resetExtraIcon();
        }
    }

    public Icon getExtraIcon() {
        return this.extraIcon;
    }

    private static Icon getDefaultIcon() {
        return UIManager.getIcon("RadioButton.icon");
    }

    private static Icon getDisabledIconSafe(JRadioButton radio) {
        Icon icon = radio.getIcon();
        if (icon == null) {
            return JExtendedRadioButton.getDefaultIcon();
        }
        Icon disabledIcon = radio.getDisabledIcon();
        return disabledIcon != null ? disabledIcon : JExtendedRadioButton.getIconSafe(radio);
    }

    private static Icon getDisabledSelectedIconSafe(JRadioButton radio) {
        Icon icon = radio.getIcon();
        if (icon == null) {
            return JExtendedRadioButton.getDefaultIcon();
        }
        Icon disabledSelectedIcon = radio.getDisabledSelectedIcon();
        return disabledSelectedIcon != null ? disabledSelectedIcon : JExtendedRadioButton.getIconSafe(radio);
    }

    private static Icon getIconSafe(JRadioButton radio) {
        Icon icon = radio.getIcon();
        return icon != null ? icon : JExtendedRadioButton.getDefaultIcon();
    }

    private static Icon getPressedIconSafe(JRadioButton radio) {
        Icon icon = radio.getIcon();
        if (icon == null) {
            return JExtendedRadioButton.getDefaultIcon();
        }
        Icon pressedIcon = radio.getPressedIcon();
        if (pressedIcon == null) {
            pressedIcon = radio.getSelectedIcon();
        }
        return pressedIcon != null ? pressedIcon : JExtendedRadioButton.getIconSafe(radio);
    }

    private static Icon getRolloverIconSafe(JRadioButton radio) {
        Icon icon = radio.getIcon();
        if (icon == null) {
            return JExtendedRadioButton.getDefaultIcon();
        }
        Icon rolloverIcon = radio.getRolloverIcon();
        return rolloverIcon != null ? rolloverIcon : JExtendedRadioButton.getIconSafe(radio);
    }

    private static Icon getRolloverSelectedIconSafe(JRadioButton radio) {
        Icon icon = radio.getIcon();
        if (icon == null) {
            return JExtendedRadioButton.getDefaultIcon();
        }
        Icon rolloverSelectedIcon = radio.getRolloverSelectedIcon();
        if (rolloverSelectedIcon == null) {
            rolloverSelectedIcon = radio.getSelectedIcon();
        }
        return rolloverSelectedIcon != null ? rolloverSelectedIcon : JExtendedRadioButton.getIconSafe(radio);
    }

    private static Icon getSelectedIconSafe(JRadioButton radio) {
        Icon icon = radio.getIcon();
        if (icon == null) {
            return JExtendedRadioButton.getDefaultIcon();
        }
        Icon selectedIcon = radio.getSelectedIcon();
        return selectedIcon != null ? selectedIcon : JExtendedRadioButton.getIconSafe(radio);
    }

    private static boolean isSupportedLaF() {
        return !UIUtils.isGTKLookAndFeel() && !UIUtils.isAquaLookAndFeel();
    }

    private void createExtraIcon() {
        JRadioButton reference = new JRadioButton();
        int iconTextGap = reference.getIconTextGap();
        Icon disabledIcon = JExtendedRadioButton.getDisabledIconSafe(reference);
        Icon disabledSelectedIcon = JExtendedRadioButton.getDisabledSelectedIconSafe(reference);
        Icon icon = JExtendedRadioButton.getIconSafe(reference);
        Icon pressedIcon = JExtendedRadioButton.getPressedIconSafe(reference);
        Icon rolloverIcon = JExtendedRadioButton.getRolloverIconSafe(reference);
        Icon rolloverSelectedIcon = JExtendedRadioButton.getRolloverSelectedIconSafe(reference);
        Icon selectedIcon = JExtendedRadioButton.getSelectedIconSafe(reference);
        this.setDisabledIcon(disabledIcon == null ? this.extraIcon : new DoubleIcon(disabledIcon, this.extraIcon, iconTextGap));
        this.setDisabledSelectedIcon(disabledSelectedIcon == null ? this.extraIcon : new DoubleIcon(disabledSelectedIcon, this.extraIcon, iconTextGap));
        this.setIcon(icon == null ? this.extraIcon : new DoubleIcon(icon, this.extraIcon, iconTextGap));
        this.setPressedIcon(pressedIcon == null ? this.extraIcon : new DoubleIcon(pressedIcon, this.extraIcon, iconTextGap));
        this.setRolloverIcon(rolloverIcon == null ? this.extraIcon : new DoubleIcon(rolloverIcon, this.extraIcon, iconTextGap));
        this.setRolloverSelectedIcon(rolloverSelectedIcon == null ? this.extraIcon : new DoubleIcon(rolloverSelectedIcon, this.extraIcon, iconTextGap));
        this.setSelectedIcon(selectedIcon == null ? this.extraIcon : new DoubleIcon(selectedIcon, this.extraIcon, iconTextGap));
    }

    private void resetExtraIcon() {
        JRadioButton reference = new JRadioButton();
        this.setDisabledIcon(reference.getDisabledIcon());
        this.setDisabledSelectedIcon(reference.getDisabledSelectedIcon());
        this.setIcon(reference.getIcon());
        this.setPressedIcon(reference.getPressedIcon());
        this.setRolloverIcon(reference.getRolloverIcon());
        this.setRolloverSelectedIcon(reference.getRolloverSelectedIcon());
        this.setSelectedIcon(reference.getSelectedIcon());
    }

    public static class DoubleIcon
    implements Icon {
        private Icon icon1;
        private Icon icon2;
        private int icon1VertOffset = 0;
        private int icon2HorzOffset;
        private int icon2VertOffset = 0;
        private int iconHeight;
        private int iconWidth;
        private int iconsGap;

        public DoubleIcon(Icon icon1, Icon icon2, int iconsGap) {
            this.icon1 = icon1;
            this.icon2 = icon2;
            this.iconsGap = iconsGap;
            this.initInternals();
        }

        public Icon getIcon1() {
            return this.icon1;
        }

        public Icon getIcon2() {
            return this.icon2;
        }

        @Override
        public int getIconHeight() {
            return this.iconHeight;
        }

        @Override
        public int getIconWidth() {
            return this.iconWidth;
        }

        public int getIconsGap() {
            return this.iconsGap;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon1.paintIcon(c, g, x, y + this.icon1VertOffset);
            this.icon2.paintIcon(c, g, x + this.icon2HorzOffset, y + this.icon2VertOffset);
        }

        private void initInternals() {
            int icon1Width = this.icon1.getIconWidth();
            int icon1Height = this.icon1.getIconHeight();
            int icon2Height = this.icon2.getIconHeight();
            this.iconWidth = icon1Width + this.icon2.getIconWidth() + this.iconsGap;
            this.iconHeight = Math.max(icon1Height, icon2Height);
            if (icon1Height > icon2Height) {
                this.icon2VertOffset = (int)Math.ceil((float)(icon1Height - icon2Height) / 2.0f);
            } else if (icon1Height < icon2Height) {
                this.icon1VertOffset = (int)Math.ceil((float)(icon2Height - icon1Height) / 2.0f);
            }
            this.icon2HorzOffset = icon1Width + this.iconsGap;
        }
    }
}

