/*
 * Decompiled with CFR 0.152.
 */
package com.zabbix.gateway;

import com.zabbix.gateway.ConfigurationParameter;
import com.zabbix.gateway.IntegerValidator;
import com.zabbix.gateway.PostInputValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationManager {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationManager.class);
    static final String PID_FILE = "pidFile";
    static final String LISTEN_IP = "listenIP";
    static final String LISTEN_PORT = "listenPort";
    static final String START_POLLERS = "startPollers";
    static final String TIMEOUT = "timeout";
    static final String PROPERTIES_FILE = "propertiesFile";
    private static ConfigurationParameter[] parameters = new ConfigurationParameter[]{new ConfigurationParameter("pidFile", 2, null, null, new PostInputValidator(){

        @Override
        public void execute(Object object) {
            logger.debug("received {} configuration parameter, daemonizing", (Object)ConfigurationManager.PID_FILE);
            File file = (File)object;
            file.deleteOnExit();
            try {
                System.in.close();
                System.out.close();
                System.err.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }), new ConfigurationParameter("listenIP", 1, null, null, null), new ConfigurationParameter("listenPort", 0, 10052, new IntegerValidator(1024, Short.MAX_VALUE), null), new ConfigurationParameter("startPollers", 0, 5, new IntegerValidator(1, 1000), null), new ConfigurationParameter("timeout", 0, 3, new IntegerValidator(1, 30), null), new ConfigurationParameter("propertiesFile", 2, null, null, new PostInputValidator(){

        @Override
        public void execute(Object object) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream((File)object);
                Properties properties = new Properties(System.getProperties());
                properties.load(fileInputStream);
                System.setProperties(properties);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            catch (SecurityException securityException) {
                throw new RuntimeException(securityException);
            }
            finally {
                try {
                    if (null != fileInputStream) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    })};

    ConfigurationManager() {
    }

    static void parseConfiguration() {
        logger.debug("starting to parse configuration parameters");
        for (ConfigurationParameter configurationParameter : parameters) {
            String string = System.getProperty("zabbix." + configurationParameter.getName());
            if (null == string) continue;
            logger.debug("found {} configuration parameter with value '{}'", (Object)configurationParameter.getName(), (Object)string);
            configurationParameter.setValue(string);
        }
        logger.debug("finished parsing configuration parameters");
    }

    static ConfigurationParameter getParameter(String string) {
        for (ConfigurationParameter configurationParameter : parameters) {
            if (!configurationParameter.getName().equals(string)) continue;
            return configurationParameter;
        }
        throw new IllegalArgumentException("unknown configuration parameter: '" + string + "'");
    }

    static int getIntegerParameterValue(String string) {
        return (Integer)ConfigurationManager.getParameter(string).getValue();
    }

    static String getPackage() {
        return "com.zabbix.gateway";
    }
}

