/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.BitSetConversionUtils;
import ch.systemsx.cisd.hdf5.HDF5CompoundByteifyerFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5MemberByteifyer;
import ch.systemsx.cisd.hdf5.HDF5ValueObjectByteifyer;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;
import java.lang.reflect.Field;
import java.util.BitSet;

class HDF5CompoundMemberByteifyerBitSetFactory
implements HDF5CompoundByteifyerFactory.IHDF5CompoundMemberBytifyerFactory {
    HDF5CompoundMemberByteifyerBitSetFactory() {
    }

    @Override
    public boolean canHandle(Class<?> clazz, HDF5CompoundMemberInformation memberInfoOrNull) {
        if (memberInfoOrNull != null) {
            return clazz == BitSet.class && memberInfoOrNull.getType().getDataClass() == HDF5DataClass.BITFIELD;
        }
        return clazz == BitSet.class;
    }

    @Override
    public Class<?> tryGetOverrideJavaType(HDF5DataClass dataClass, int rank, int elementSize, HDF5DataTypeVariant typeVariantOrNull) {
        return null;
    }

    @Override
    public HDF5MemberByteifyer createBytifyer(HDF5CompoundByteifyerFactory.AccessType accessType, Field fieldOrNull, HDF5CompoundMemberMapping member, HDF5CompoundMemberInformation compoundMemberInfoOrNull, HDF5EnumerationType enumTypeOrNull, Class<?> memberClazz, int index, int offset, HDF5ValueObjectByteifyer.FileInfoProvider fileInfoProvider) {
        int memberTypeLengthInLongs;
        String memberName = member.getMemberName();
        if (compoundMemberInfoOrNull == null) {
            int memberTypeLengthInBits = member.getMemberTypeLength();
            memberTypeLengthInLongs = memberTypeLengthInBits / 64 + (memberTypeLengthInBits % 64 != 0 ? 1 : 0);
        } else {
            memberTypeLengthInLongs = compoundMemberInfoOrNull.getType().getNumberOfElements();
        }
        if (memberTypeLengthInLongs <= 0) {
            throw new IllegalArgumentException("Length of a bit field must be a positive number (len=" + memberTypeLengthInLongs + ").");
        }
        int storageTypeId = member.getStorageDataTypeId();
        int memberTypeId = storageTypeId < 0 ? fileInfoProvider.getArrayTypeId(HDF5Constants.H5T_STD_B64LE, memberTypeLengthInLongs) : storageTypeId;
        switch (accessType) {
            case FIELD: {
                return this.createByteifyerForField(fieldOrNull, memberName, offset, memberTypeLengthInLongs, memberTypeId, member.tryGetTypeVariant());
            }
            case MAP: {
                return this.createByteifyerForMap(memberName, offset, memberTypeLengthInLongs, memberTypeId, member.tryGetTypeVariant());
            }
            case LIST: {
                return this.createByteifyerForList(memberName, index, offset, memberTypeLengthInLongs, memberTypeId, member.tryGetTypeVariant());
            }
            case ARRAY: {
                return this.createByteifyerForArray(memberName, index, offset, memberTypeLengthInLongs, memberTypeId, member.tryGetTypeVariant());
            }
        }
        throw new Error("Unknown access type");
    }

    private HDF5MemberByteifyer createByteifyerForField(final Field field, String memberName, int offset, final int memberTypeLengthInLongs, final int memberTypeId, HDF5DataTypeVariant typeVariant) {
        ReflectionUtils.ensureAccessible(field);
        return new HDF5MemberByteifyer(field, memberName, memberTypeLengthInLongs * 8, offset, typeVariant){

            @Override
            protected int getMemberStorageTypeId() {
                return memberTypeId;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                BitSet bs = (BitSet)field.get(obj);
                return HDFNativeData.longToByte(BitSetConversionUtils.toStorageForm(bs));
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                BitSet bs = BitSetConversionUtils.fromStorageForm(HDFNativeData.byteToLong(byteArr, arrayOffset + this.offset, memberTypeLengthInLongs));
                field.set(obj, bs);
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForMap(final String memberName, int offset, final int memberTypeLengthInLongs, final int memberTypeId, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, memberTypeLengthInLongs * 8, offset, typeVariant){

            @Override
            protected int getMemberStorageTypeId() {
                return memberTypeId;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                BitSet bs = (BitSet)HDF5CompoundByteifyerFactory.getMap(obj, memberName);
                return HDFNativeData.longToByte(BitSetConversionUtils.toStorageForm(bs));
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                BitSet bitSet = BitSetConversionUtils.fromStorageForm(HDFNativeData.byteToLong(byteArr, arrayOffset + this.offset, memberTypeLengthInLongs));
                HDF5CompoundByteifyerFactory.putMap(obj, memberName, bitSet);
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForList(String memberName, final int index, int offset, final int memberTypeLengthInLongs, final int memberTypeId, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, memberTypeLengthInLongs * 8, offset, typeVariant){

            @Override
            protected int getMemberStorageTypeId() {
                return memberTypeId;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                BitSet bs = (BitSet)HDF5CompoundByteifyerFactory.getList(obj, index);
                return HDFNativeData.longToByte(BitSetConversionUtils.toStorageForm(bs));
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                BitSet bitSet = BitSetConversionUtils.fromStorageForm(HDFNativeData.byteToLong(byteArr, arrayOffset + this.offset, memberTypeLengthInLongs));
                HDF5CompoundByteifyerFactory.setList(obj, index, bitSet);
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForArray(String memberName, final int index, int offset, final int memberTypeLengthInLongs, final int memberTypeId, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, memberTypeLengthInLongs * 8, offset, typeVariant){

            @Override
            protected int getMemberStorageTypeId() {
                return memberTypeId;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                BitSet bs = (BitSet)HDF5CompoundByteifyerFactory.getArray(obj, index);
                return HDFNativeData.longToByte(BitSetConversionUtils.toStorageForm(bs));
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                BitSet bitSet = BitSetConversionUtils.fromStorageForm(HDFNativeData.byteToLong(byteArr, arrayOffset + this.offset, memberTypeLengthInLongs));
                HDF5CompoundByteifyerFactory.setArray(obj, index, bitSet);
            }
        };
    }
}

