require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_CURSES_H_)) {
    eval 'sub _CURSES_H_ () {1;}' unless defined(&_CURSES_H_);
    require 'sys/types.ph';
    require 'sys/cdefs.ph';
    require 'wchar.ph';
    require 'stdio.ph';
    require 'stdbool.ph';
    if(!defined(&HAVE_WCHAR)  && !defined(&DISABLE_WCHAR)) {
	eval 'sub HAVE_WCHAR () {1;}' unless defined(&HAVE_WCHAR);
    }
    if(defined(&HAVE_WCHAR)) {
	eval 'sub CURSES_CCHAR_MAX () {8;}' unless defined(&CURSES_CCHAR_MAX);
	eval 'sub CCHARW_MAX () {5;}' unless defined(&CCHARW_MAX);
    } else {
    }
    unless(defined(&TRUE)) {
	eval 'sub TRUE () {( 1);}' unless defined(&TRUE);
    }
    unless(defined(&FALSE)) {
	eval 'sub FALSE () {( 0);}' unless defined(&FALSE);
    }
    unless(defined(&_CURSES_PRIVATE)) {
	eval 'sub _puts {
	    my($s) = @_;
    	    eval q( &tputs($s, 0,  &__cputchar));
	}' unless defined(&_puts);
	eval 'sub _putchar {
	    my($c) = @_;
    	    eval q( &__cputchar($c));
	}' unless defined(&_putchar);
	eval 'sub crmode () {
	    eval q( &cbreak());
	}' unless defined(&crmode);
	eval 'sub nocrmode () {
	    eval q( &nocbreak());
	}' unless defined(&nocrmode);
    }
    eval 'sub KEY_MIN () {0x101;}' unless defined(&KEY_MIN);
    eval 'sub KEY_BREAK () {0x101;}' unless defined(&KEY_BREAK);
    eval 'sub KEY_DOWN () {0x102;}' unless defined(&KEY_DOWN);
    eval 'sub KEY_UP () {0x103;}' unless defined(&KEY_UP);
    eval 'sub KEY_LEFT () {0x104;}' unless defined(&KEY_LEFT);
    eval 'sub KEY_RIGHT () {0x105;}' unless defined(&KEY_RIGHT);
    eval 'sub KEY_HOME () {0x106;}' unless defined(&KEY_HOME);
    eval 'sub KEY_BACKSPACE () {0x107;}' unless defined(&KEY_BACKSPACE);
    eval 'sub KEY_F0 () {0x108;}' unless defined(&KEY_F0);
    eval 'sub KEY_F {
        my($n) = @_;
	    eval q(( &KEY_F0+($n)));
    }' unless defined(&KEY_F);
    eval 'sub KEY_DL () {0x148;}' unless defined(&KEY_DL);
    eval 'sub KEY_IL () {0x149;}' unless defined(&KEY_IL);
    eval 'sub KEY_DC () {0x14a;}' unless defined(&KEY_DC);
    eval 'sub KEY_IC () {0x14b;}' unless defined(&KEY_IC);
    eval 'sub KEY_EIC () {0x14c;}' unless defined(&KEY_EIC);
    eval 'sub KEY_CLEAR () {0x14d;}' unless defined(&KEY_CLEAR);
    eval 'sub KEY_EOS () {0x14e;}' unless defined(&KEY_EOS);
    eval 'sub KEY_EOL () {0x14f;}' unless defined(&KEY_EOL);
    eval 'sub KEY_SF () {0x150;}' unless defined(&KEY_SF);
    eval 'sub KEY_SR () {0x151;}' unless defined(&KEY_SR);
    eval 'sub KEY_NPAGE () {0x152;}' unless defined(&KEY_NPAGE);
    eval 'sub KEY_PPAGE () {0x153;}' unless defined(&KEY_PPAGE);
    eval 'sub KEY_STAB () {0x154;}' unless defined(&KEY_STAB);
    eval 'sub KEY_CTAB () {0x155;}' unless defined(&KEY_CTAB);
    eval 'sub KEY_CATAB () {0x156;}' unless defined(&KEY_CATAB);
    eval 'sub KEY_ENTER () {0x157;}' unless defined(&KEY_ENTER);
    eval 'sub KEY_SRESET () {0x158;}' unless defined(&KEY_SRESET);
    eval 'sub KEY_RESET () {0x159;}' unless defined(&KEY_RESET);
    eval 'sub KEY_PRINT () {0x15a;}' unless defined(&KEY_PRINT);
    eval 'sub KEY_LL () {0x15b;}' unless defined(&KEY_LL);
    eval 'sub KEY_A1 () {0x15c;}' unless defined(&KEY_A1);
    eval 'sub KEY_A3 () {0x15d;}' unless defined(&KEY_A3);
    eval 'sub KEY_B2 () {0x15e;}' unless defined(&KEY_B2);
    eval 'sub KEY_C1 () {0x15f;}' unless defined(&KEY_C1);
    eval 'sub KEY_C3 () {0x160;}' unless defined(&KEY_C3);
    eval 'sub KEY_BTAB () {0x161;}' unless defined(&KEY_BTAB);
    eval 'sub KEY_BEG () {0x162;}' unless defined(&KEY_BEG);
    eval 'sub KEY_CANCEL () {0x163;}' unless defined(&KEY_CANCEL);
    eval 'sub KEY_CLOSE () {0x164;}' unless defined(&KEY_CLOSE);
    eval 'sub KEY_COMMAND () {0x165;}' unless defined(&KEY_COMMAND);
    eval 'sub KEY_COPY () {0x166;}' unless defined(&KEY_COPY);
    eval 'sub KEY_CREATE () {0x167;}' unless defined(&KEY_CREATE);
    eval 'sub KEY_END () {0x168;}' unless defined(&KEY_END);
    eval 'sub KEY_EXIT () {0x169;}' unless defined(&KEY_EXIT);
    eval 'sub KEY_FIND () {0x16a;}' unless defined(&KEY_FIND);
    eval 'sub KEY_HELP () {0x16b;}' unless defined(&KEY_HELP);
    eval 'sub KEY_MARK () {0x16c;}' unless defined(&KEY_MARK);
    eval 'sub KEY_MESSAGE () {0x16d;}' unless defined(&KEY_MESSAGE);
    eval 'sub KEY_MOVE () {0x16e;}' unless defined(&KEY_MOVE);
    eval 'sub KEY_NEXT () {0x16f;}' unless defined(&KEY_NEXT);
    eval 'sub KEY_OPEN () {0x170;}' unless defined(&KEY_OPEN);
    eval 'sub KEY_OPTIONS () {0x171;}' unless defined(&KEY_OPTIONS);
    eval 'sub KEY_PREVIOUS () {0x172;}' unless defined(&KEY_PREVIOUS);
    eval 'sub KEY_REDO () {0x173;}' unless defined(&KEY_REDO);
    eval 'sub KEY_REFERENCE () {0x174;}' unless defined(&KEY_REFERENCE);
    eval 'sub KEY_REFRESH () {0x175;}' unless defined(&KEY_REFRESH);
    eval 'sub KEY_REPLACE () {0x176;}' unless defined(&KEY_REPLACE);
    eval 'sub KEY_RESTART () {0x177;}' unless defined(&KEY_RESTART);
    eval 'sub KEY_RESUME () {0x178;}' unless defined(&KEY_RESUME);
    eval 'sub KEY_SAVE () {0x179;}' unless defined(&KEY_SAVE);
    eval 'sub KEY_SBEG () {0x17a;}' unless defined(&KEY_SBEG);
    eval 'sub KEY_SCANCEL () {0x17b;}' unless defined(&KEY_SCANCEL);
    eval 'sub KEY_SCOMMAND () {0x17c;}' unless defined(&KEY_SCOMMAND);
    eval 'sub KEY_SCOPY () {0x17d;}' unless defined(&KEY_SCOPY);
    eval 'sub KEY_SCREATE () {0x17e;}' unless defined(&KEY_SCREATE);
    eval 'sub KEY_SDC () {0x17f;}' unless defined(&KEY_SDC);
    eval 'sub KEY_SDL () {0x180;}' unless defined(&KEY_SDL);
    eval 'sub KEY_SELECT () {0x181;}' unless defined(&KEY_SELECT);
    eval 'sub KEY_SEND () {0x182;}' unless defined(&KEY_SEND);
    eval 'sub KEY_SEOL () {0x183;}' unless defined(&KEY_SEOL);
    eval 'sub KEY_SEXIT () {0x184;}' unless defined(&KEY_SEXIT);
    eval 'sub KEY_SFIND () {0x185;}' unless defined(&KEY_SFIND);
    eval 'sub KEY_SHELP () {0x186;}' unless defined(&KEY_SHELP);
    eval 'sub KEY_SHOME () {0x187;}' unless defined(&KEY_SHOME);
    eval 'sub KEY_SIC () {0x188;}' unless defined(&KEY_SIC);
    eval 'sub KEY_SLEFT () {0x189;}' unless defined(&KEY_SLEFT);
    eval 'sub KEY_SMESSAGE () {0x18a;}' unless defined(&KEY_SMESSAGE);
    eval 'sub KEY_SMOVE () {0x18b;}' unless defined(&KEY_SMOVE);
    eval 'sub KEY_SNEXT () {0x18c;}' unless defined(&KEY_SNEXT);
    eval 'sub KEY_SOPTIONS () {0x18d;}' unless defined(&KEY_SOPTIONS);
    eval 'sub KEY_SPREVIOUS () {0x18e;}' unless defined(&KEY_SPREVIOUS);
    eval 'sub KEY_SPRINT () {0x18f;}' unless defined(&KEY_SPRINT);
    eval 'sub KEY_SREDO () {0x190;}' unless defined(&KEY_SREDO);
    eval 'sub KEY_SREPLACE () {0x191;}' unless defined(&KEY_SREPLACE);
    eval 'sub KEY_SRIGHT () {0x192;}' unless defined(&KEY_SRIGHT);
    eval 'sub KEY_SRSUME () {0x193;}' unless defined(&KEY_SRSUME);
    eval 'sub KEY_SSAVE () {0x194;}' unless defined(&KEY_SSAVE);
    eval 'sub KEY_SSUSPEND () {0x195;}' unless defined(&KEY_SSUSPEND);
    eval 'sub KEY_SUNDO () {0x196;}' unless defined(&KEY_SUNDO);
    eval 'sub KEY_SUSPEND () {0x197;}' unless defined(&KEY_SUSPEND);
    eval 'sub KEY_UNDO () {0x198;}' unless defined(&KEY_UNDO);
    eval 'sub KEY_MOUSE () {0x199;}' unless defined(&KEY_MOUSE);
    eval 'sub KEY_RESIZE () {0x200;}' unless defined(&KEY_RESIZE);
    eval 'sub KEY_MAX () {0x240;}' unless defined(&KEY_MAX);
    eval 'sub KEY_CODE_YES () {0x241;}' unless defined(&KEY_CODE_YES);
    require 'unctrl.ph';
    eval 'sub __CHARTEXT () {0xff;}' unless defined(&__CHARTEXT);
    eval 'sub __NORMAL () {0x;}' unless defined(&__NORMAL);
    eval 'sub __STANDOUT () {0x100;}' unless defined(&__STANDOUT);
    eval 'sub __UNDERSCORE () {0x200;}' unless defined(&__UNDERSCORE);
    eval 'sub __REVERSE () {0x400;}' unless defined(&__REVERSE);
    eval 'sub __BLINK () {0x800;}' unless defined(&__BLINK);
    eval 'sub __DIM () {0x1000;}' unless defined(&__DIM);
    eval 'sub __BOLD () {0x2000;}' unless defined(&__BOLD);
    eval 'sub __BLANK () {0x4000;}' unless defined(&__BLANK);
    eval 'sub __PROTECT () {0x8000;}' unless defined(&__PROTECT);
    eval 'sub __ALTCHARSET () {0x10000;}' unless defined(&__ALTCHARSET);
    eval 'sub __COLOR () {0x3fe0000;}' unless defined(&__COLOR);
    eval 'sub __ATTRIBUTES () {0x3ffff00;}' unless defined(&__ATTRIBUTES);
    if(defined(&HAVE_WCHAR)) {
	eval 'sub __ACS_IS_WACS () {0x4000000;}' unless defined(&__ACS_IS_WACS);
    }
    eval 'sub A_NORMAL () { &__NORMAL;}' unless defined(&A_NORMAL);
    eval 'sub A_STANDOUT () { &__STANDOUT;}' unless defined(&A_STANDOUT);
    eval 'sub A_UNDERLINE () { &__UNDERSCORE;}' unless defined(&A_UNDERLINE);
    eval 'sub A_REVERSE () { &__REVERSE;}' unless defined(&A_REVERSE);
    eval 'sub A_BLINK () { &__BLINK;}' unless defined(&A_BLINK);
    eval 'sub A_DIM () { &__DIM;}' unless defined(&A_DIM);
    eval 'sub A_BOLD () { &__BOLD;}' unless defined(&A_BOLD);
    eval 'sub A_BLANK () { &__BLANK;}' unless defined(&A_BLANK);
    eval 'sub A_INVIS () { &__BLANK;}' unless defined(&A_INVIS);
    eval 'sub A_PROTECT () { &__PROTECT;}' unless defined(&A_PROTECT);
    eval 'sub A_ALTCHARSET () { &__ALTCHARSET;}' unless defined(&A_ALTCHARSET);
    eval 'sub A_ATTRIBUTES () { &__ATTRIBUTES;}' unless defined(&A_ATTRIBUTES);
    eval 'sub A_CHARTEXT () { &__CHARTEXT;}' unless defined(&A_CHARTEXT);
    eval 'sub A_COLOR () { &__COLOR;}' unless defined(&A_COLOR);
    if(defined(&HAVE_WCHAR)) {
	eval 'sub WA_ATTRIBUTES () {0x3ffffff;}' unless defined(&WA_ATTRIBUTES);
	eval 'sub WA_NORMAL () { &__NORMAL;}' unless defined(&WA_NORMAL);
	eval 'sub WA_STANDOUT () { &__STANDOUT;}' unless defined(&WA_STANDOUT);
	eval 'sub WA_UNDERLINE () { &__UNDERSCORE;}' unless defined(&WA_UNDERLINE);
	eval 'sub WA_REVERSE () { &__REVERSE;}' unless defined(&WA_REVERSE);
	eval 'sub WA_BLINK () { &__BLINK;}' unless defined(&WA_BLINK);
	eval 'sub WA_DIM () { &__DIM;}' unless defined(&WA_DIM);
	eval 'sub WA_BOLD () { &__BOLD;}' unless defined(&WA_BOLD);
	eval 'sub WA_INVIS () { &__BLANK;}' unless defined(&WA_INVIS);
	eval 'sub WA_PROTECT () { &__PROTECT;}' unless defined(&WA_PROTECT);
	eval 'sub WA_ALTCHARSET () { &__ALTCHARSET;}' unless defined(&WA_ALTCHARSET);
	eval 'sub WA_LOW () {0x2;}' unless defined(&WA_LOW);
	eval 'sub WA_TOP () {0x4;}' unless defined(&WA_TOP);
	eval 'sub WA_HORIZONTAL () {0x8;}' unless defined(&WA_HORIZONTAL);
	eval 'sub WA_VERTICAL () {0x10;}' unless defined(&WA_VERTICAL);
	eval 'sub WA_LEFT () {0x20;}' unless defined(&WA_LEFT);
	eval 'sub WA_RIGHT () {0x40;}' unless defined(&WA_RIGHT);
    }
    eval 'sub NUM_ACS () {128;}' unless defined(&NUM_ACS);
    if(defined(&__cplusplus)) {
	eval 'sub __UC_CAST {
	    my($a) = @_;
    	    eval q( &static_cast<\'unsigned char\'>($a));
	}' unless defined(&__UC_CAST);
    } else {
	eval 'sub __UC_CAST {
	    my($a) = @_;
    	    eval q(($a));
	}' unless defined(&__UC_CAST);
    }
    eval 'sub ACS_RARROW () { $_acs_char[ &__UC_CAST(ord(\'+\'))];}' unless defined(&ACS_RARROW);
    eval 'sub ACS_LARROW () { $_acs_char[ &__UC_CAST(ord(\',\'))];}' unless defined(&ACS_LARROW);
    eval 'sub ACS_UARROW () { $_acs_char[ &__UC_CAST(ord(\'-\'))];}' unless defined(&ACS_UARROW);
    eval 'sub ACS_DARROW () { $_acs_char[ &__UC_CAST(ord(\'.\'))];}' unless defined(&ACS_DARROW);
    eval 'sub ACS_BLOCK () { $_acs_char[ &__UC_CAST(ord(\'0\'))];}' unless defined(&ACS_BLOCK);
    eval 'sub ACS_DIAMOND () { $_acs_char[ &__UC_CAST(ord(\'`\'))];}' unless defined(&ACS_DIAMOND);
    eval 'sub ACS_CKBOARD () { $_acs_char[ &__UC_CAST(ord(\'a\'))];}' unless defined(&ACS_CKBOARD);
    eval 'sub ACS_DEGREE () { $_acs_char[ &__UC_CAST(ord(\'f\'))];}' unless defined(&ACS_DEGREE);
    eval 'sub ACS_PLMINUS () { $_acs_char[ &__UC_CAST(ord(\'g\'))];}' unless defined(&ACS_PLMINUS);
    eval 'sub ACS_BOARD () { $_acs_char[ &__UC_CAST(ord(\'h\'))];}' unless defined(&ACS_BOARD);
    eval 'sub ACS_LANTERN () { $_acs_char[ &__UC_CAST(ord(\'i\'))];}' unless defined(&ACS_LANTERN);
    eval 'sub ACS_LRCORNER () { $_acs_char[ &__UC_CAST(ord(\'j\'))];}' unless defined(&ACS_LRCORNER);
    eval 'sub ACS_URCORNER () { $_acs_char[ &__UC_CAST(ord(\'k\'))];}' unless defined(&ACS_URCORNER);
    eval 'sub ACS_ULCORNER () { $_acs_char[ &__UC_CAST(ord(\'l\'))];}' unless defined(&ACS_ULCORNER);
    eval 'sub ACS_LLCORNER () { $_acs_char[ &__UC_CAST(ord(\'m\'))];}' unless defined(&ACS_LLCORNER);
    eval 'sub ACS_PLUS () { $_acs_char[ &__UC_CAST(ord(\'n\'))];}' unless defined(&ACS_PLUS);
    eval 'sub ACS_HLINE () { $_acs_char[ &__UC_CAST(ord(\'q\'))];}' unless defined(&ACS_HLINE);
    eval 'sub ACS_S1 () { $_acs_char[ &__UC_CAST(ord(\'o\'))];}' unless defined(&ACS_S1);
    eval 'sub ACS_S9 () { $_acs_char[ &__UC_CAST(ord(\'s\'))];}' unless defined(&ACS_S9);
    eval 'sub ACS_LTEE () { $_acs_char[ &__UC_CAST(ord(\'t\'))];}' unless defined(&ACS_LTEE);
    eval 'sub ACS_RTEE () { $_acs_char[ &__UC_CAST(ord(\'u\'))];}' unless defined(&ACS_RTEE);
    eval 'sub ACS_BTEE () { $_acs_char[ &__UC_CAST(ord(\'v\'))];}' unless defined(&ACS_BTEE);
    eval 'sub ACS_TTEE () { $_acs_char[ &__UC_CAST(ord(\'w\'))];}' unless defined(&ACS_TTEE);
    eval 'sub ACS_VLINE () { $_acs_char[ &__UC_CAST(ord(\'x\'))];}' unless defined(&ACS_VLINE);
    eval 'sub ACS_BULLET () { $_acs_char[ &__UC_CAST(ord(\'~\'))];}' unless defined(&ACS_BULLET);
    eval 'sub ACS_S3 () { $_acs_char[ &__UC_CAST(ord(\'p\'))];}' unless defined(&ACS_S3);
    eval 'sub ACS_S7 () { $_acs_char[ &__UC_CAST(ord(\'r\'))];}' unless defined(&ACS_S7);
    eval 'sub ACS_LEQUAL () { $_acs_char[ &__UC_CAST(ord(\'y\'))];}' unless defined(&ACS_LEQUAL);
    eval 'sub ACS_GEQUAL () { $_acs_char[ &__UC_CAST(ord(\'z\'))];}' unless defined(&ACS_GEQUAL);
    eval 'sub ACS_PI () { $_acs_char[ &__UC_CAST(ord(\'{\'))];}' unless defined(&ACS_PI);
    eval 'sub ACS_NEQUAL () { $_acs_char[ &__UC_CAST(ord(\'|\'))];}' unless defined(&ACS_NEQUAL);
    eval 'sub ACS_STERLING () { $_acs_char[ &__UC_CAST(ord(\'}\'))];}' unless defined(&ACS_STERLING);
    if(defined(&HAVE_WCHAR)) {
	eval 'sub WACS_RARROW () {(& $_wacs_char[ord(\'+\')]);}' unless defined(&WACS_RARROW);
	eval 'sub WACS_LARROW () {(& $_wacs_char[ord(\',\')]);}' unless defined(&WACS_LARROW);
	eval 'sub WACS_UARROW () {(& $_wacs_char[ord(\'-\')]);}' unless defined(&WACS_UARROW);
	eval 'sub WACS_DARROW () {(& $_wacs_char[ord(\'.\')]);}' unless defined(&WACS_DARROW);
	eval 'sub WACS_BLOCK () {(& $_wacs_char[ord(\'0\')]);}' unless defined(&WACS_BLOCK);
	eval 'sub WACS_DIAMOND () {(& $_wacs_char[ord(\'`\')]);}' unless defined(&WACS_DIAMOND);
	eval 'sub WACS_CKBOARD () {(& $_wacs_char[ord(\'a\')]);}' unless defined(&WACS_CKBOARD);
	eval 'sub WACS_DEGREE () {(& $_wacs_char[ord(\'f\')]);}' unless defined(&WACS_DEGREE);
	eval 'sub WACS_PLMINUS () {(& $_wacs_char[ord(\'g\')]);}' unless defined(&WACS_PLMINUS);
	eval 'sub WACS_BOARD () {(& $_wacs_char[ord(\'h\')]);}' unless defined(&WACS_BOARD);
	eval 'sub WACS_LANTERN () {(& $_wacs_char[ord(\'i\')]);}' unless defined(&WACS_LANTERN);
	eval 'sub WACS_LRCORNER () {(& $_wacs_char[ord(\'j\')]);}' unless defined(&WACS_LRCORNER);
	eval 'sub WACS_URCORNER () {(& $_wacs_char[ord(\'k\')]);}' unless defined(&WACS_URCORNER);
	eval 'sub WACS_ULCORNER () {(& $_wacs_char[ord(\'l\')]);}' unless defined(&WACS_ULCORNER);
	eval 'sub WACS_LLCORNER () {(& $_wacs_char[ord(\'m\')]);}' unless defined(&WACS_LLCORNER);
	eval 'sub WACS_PLUS () {(& $_wacs_char[ord(\'n\')]);}' unless defined(&WACS_PLUS);
	eval 'sub WACS_HLINE () {(& $_wacs_char[ord(\'q\')]);}' unless defined(&WACS_HLINE);
	eval 'sub WACS_S1 () {(& $_wacs_char[ord(\'o\')]);}' unless defined(&WACS_S1);
	eval 'sub WACS_S9 () {(& $_wacs_char[ord(\'s\')]);}' unless defined(&WACS_S9);
	eval 'sub WACS_LTEE () {(& $_wacs_char[ord(\'t\')]);}' unless defined(&WACS_LTEE);
	eval 'sub WACS_RTEE () {(& $_wacs_char[ord(\'u\')]);}' unless defined(&WACS_RTEE);
	eval 'sub WACS_BTEE () {(& $_wacs_char[ord(\'v\')]);}' unless defined(&WACS_BTEE);
	eval 'sub WACS_TTEE () {(& $_wacs_char[ord(\'w\')]);}' unless defined(&WACS_TTEE);
	eval 'sub WACS_VLINE () {(& $_wacs_char[ord(\'x\')]);}' unless defined(&WACS_VLINE);
	eval 'sub WACS_BULLET () {(& $_wacs_char[ord(\'~\')]);}' unless defined(&WACS_BULLET);
	eval 'sub WACS_S3 () {(& $_wacs_char[ord(\'p\')]);}' unless defined(&WACS_S3);
	eval 'sub WACS_S7 () {(& $_wacs_char[ord(\'r\')]);}' unless defined(&WACS_S7);
	eval 'sub WACS_LEQUAL () {(& $_wacs_char[ord(\'y\')]);}' unless defined(&WACS_LEQUAL);
	eval 'sub WACS_GEQUAL () {(& $_wacs_char[ord(\'z\')]);}' unless defined(&WACS_GEQUAL);
	eval 'sub WACS_PI () {(& $_wacs_char[ord(\'{\')]);}' unless defined(&WACS_PI);
	eval 'sub WACS_NEQUAL () {(& $_wacs_char[ord(\'|\')]);}' unless defined(&WACS_NEQUAL);
	eval 'sub WACS_STERLING () {(& $_wacs_char[ord(\'}\')]);}' unless defined(&WACS_STERLING);
    }
    eval 'sub ACS_SBBS () { &ACS_LRCORNER;}' unless defined(&ACS_SBBS);
    eval 'sub ACS_BBSS () { &ACS_URCORNER;}' unless defined(&ACS_BBSS);
    eval 'sub ACS_BSSB () { &ACS_ULCORNER;}' unless defined(&ACS_BSSB);
    eval 'sub ACS_SSBB () { &ACS_LLCORNER;}' unless defined(&ACS_SSBB);
    eval 'sub ACS_SSSS () { &ACS_PLUS;}' unless defined(&ACS_SSSS);
    eval 'sub ACS_BSBS () { &ACS_HLINE;}' unless defined(&ACS_BSBS);
    eval 'sub ACS_SSSB () { &ACS_LTEE;}' unless defined(&ACS_SSSB);
    eval 'sub ACS_SBSS () { &ACS_RTEE;}' unless defined(&ACS_SBSS);
    eval 'sub ACS_SSBS () { &ACS_BTEE;}' unless defined(&ACS_SSBS);
    eval 'sub ACS_BSSS () { &ACS_TTEE;}' unless defined(&ACS_BSSS);
    eval 'sub ACS_SBSB () { &ACS_VLINE;}' unless defined(&ACS_SBSB);
    eval 'sub _acs_map () { &_acs_char;}' unless defined(&_acs_map);
    eval 'sub COLOR_BLACK () {0x;}' unless defined(&COLOR_BLACK);
    eval 'sub COLOR_RED () {0x1;}' unless defined(&COLOR_RED);
    eval 'sub COLOR_GREEN () {0x2;}' unless defined(&COLOR_GREEN);
    eval 'sub COLOR_YELLOW () {0x3;}' unless defined(&COLOR_YELLOW);
    eval 'sub COLOR_BLUE () {0x4;}' unless defined(&COLOR_BLUE);
    eval 'sub COLOR_MAGENTA () {0x5;}' unless defined(&COLOR_MAGENTA);
    eval 'sub COLOR_CYAN () {0x6;}' unless defined(&COLOR_CYAN);
    eval 'sub COLOR_WHITE () {0x7;}' unless defined(&COLOR_WHITE);
    if(defined(&__cplusplus)) {
	eval 'sub __UINT32_CAST {
	    my($a) = @_;
    	    eval q( &static_cast< &uint32_t>($a));
	}' unless defined(&__UINT32_CAST);
    } else {
	eval 'sub __UINT32_CAST {
	    my($a) = @_;
    	    eval q(( &uint32_t)($a));
	}' unless defined(&__UINT32_CAST);
    }
    eval 'sub COLOR_PAIR {
        my($n) = @_;
	    eval q(((( &__UINT32_CAST($n)) << 17) &  &A_COLOR));
    }' unless defined(&COLOR_PAIR);
    eval 'sub PAIR_NUMBER {
        my($n) = @_;
	    eval q(((( &__UINT32_CAST($n)) &  &A_COLOR) >> 17));
    }' unless defined(&PAIR_NUMBER);
    unless(defined(&OK)) {
	eval 'sub ERR () {(-1);}' unless defined(&ERR);
	eval 'sub OK () {(0);}' unless defined(&OK);
    }
    if(defined(&_CURSES_USE_MACROS)) {
	eval 'sub addbytes {
	    my($s, $n) = @_;
    	    eval q( &__waddbytes( &stdscr, $s, $n, 0));
	}' unless defined(&addbytes);
	eval 'sub addch {
	    my($ch) = @_;
    	    eval q( &waddch( &stdscr, $ch));
	}' unless defined(&addch);
	eval 'sub addchnstr {
	    my($s, $n) = @_;
    	    eval q( &waddchnstr( &stdscr, $s, $n));
	}' unless defined(&addchnstr);
	eval 'sub addchstr {
	    my($s) = @_;
    	    eval q( &waddchnstr( &stdscr, $s, -1));
	}' unless defined(&addchstr);
	eval 'sub addnstr {
	    my($s, $n) = @_;
    	    eval q( &waddnstr( &stdscr, $s, $n));
	}' unless defined(&addnstr);
	eval 'sub addstr {
	    my($s) = @_;
    	    eval q( &waddnstr( &stdscr, $s, -1));
	}' unless defined(&addstr);
	eval 'sub attr_get {
	    my($a, $p, $o) = @_;
    	    eval q( &wattr_get( &stdscr, $a, $p, $o));
	}' unless defined(&attr_get);
	eval 'sub attr_off {
	    my($a, $o) = @_;
    	    eval q( &wattr_off( &stdscr, $a, $o));
	}' unless defined(&attr_off);
	eval 'sub attr_on {
	    my($a, $o) = @_;
    	    eval q( &wattr_on( &stdscr, $a, $o));
	}' unless defined(&attr_on);
	eval 'sub attr_set {
	    my($a, $p, $o) = @_;
    	    eval q( &wattr_set( &stdscr, $a, $p, $o));
	}' unless defined(&attr_set);
	eval 'sub attroff {
	    my($attr) = @_;
    	    eval q( &wattroff( &stdscr, $attr));
	}' unless defined(&attroff);
	eval 'sub attron {
	    my($attr) = @_;
    	    eval q( &wattron( &stdscr, $attr));
	}' unless defined(&attron);
	eval 'sub attrset {
	    my($attr) = @_;
    	    eval q( &wattrset( &stdscr, $attr));
	}' unless defined(&attrset);
	eval 'sub bkgd {
	    my($ch) = @_;
    	    eval q( &wbkgd( &stdscr, $ch));
	}' unless defined(&bkgd);
	eval 'sub bkgdset {
	    my($ch) = @_;
    	    eval q( &wbkgdset( &stdscr, $ch));
	}' unless defined(&bkgdset);
	eval 'sub border {
	    my($l, $r, $t, $b, $tl, $tr, $bl, $br) = @_;
    	    eval q( &wborder( &stdscr, $l, $r, $t, $b, $tl, $tr, $bl, $br));
	}' unless defined(&border);
	eval 'sub clear () {
	    eval q( &wclear( &stdscr));
	}' unless defined(&clear);
	eval 'sub clrtobot () {
	    eval q( &wclrtobot( &stdscr));
	}' unless defined(&clrtobot);
	eval 'sub clrtoeol () {
	    eval q( &wclrtoeol( &stdscr));
	}' unless defined(&clrtoeol);
	eval 'sub color_set {
	    my($c, $o) = @_;
    	    eval q( &wcolor_set( &stdscr, $c, $o));
	}' unless defined(&color_set);
	eval 'sub delch () {
	    eval q( &wdelch( &stdscr));
	}' unless defined(&delch);
	eval 'sub deleteln () {
	    eval q( &wdeleteln( &stdscr));
	}' unless defined(&deleteln);
	eval 'sub echochar {
	    my($c) = @_;
    	    eval q( &wechochar( &stdscr, $c));
	}' unless defined(&echochar);
	eval 'sub erase () {
	    eval q( &werase( &stdscr));
	}' unless defined(&erase);
	eval 'sub getch () {
	    eval q( &wgetch( &stdscr));
	}' unless defined(&getch);
	eval 'sub getnstr {
	    my($s, $n) = @_;
    	    eval q( &wgetnstr( &stdscr, $s, $n));
	}' unless defined(&getnstr);
	eval 'sub getstr {
	    my($s) = @_;
    	    eval q( &wgetstr( &stdscr, $s));
	}' unless defined(&getstr);
	eval 'sub inch () {
	    eval q( &winch( &stdscr));
	}' unless defined(&inch);
	eval 'sub inchnstr {
	    my($c) = @_;
    	    eval q( &winchnstr( &stdscr, $c));
	}' unless defined(&inchnstr);
	eval 'sub inchstr {
	    my($c) = @_;
    	    eval q( &winchstr( &stdscr, $c));
	}' unless defined(&inchstr);
	eval 'sub innstr {
	    my($s, $n) = @_;
    	    eval q( &winnstr( &stdscr, $s, $n));
	}' unless defined(&innstr);
	eval 'sub insch {
	    my($ch) = @_;
    	    eval q( &winsch( &stdscr, $ch));
	}' unless defined(&insch);
	eval 'sub insdelln {
	    my($n) = @_;
    	    eval q( &winsdelln( &stdscr, $n));
	}' unless defined(&insdelln);
	eval 'sub insertln () {
	    eval q( &winsertln( &stdscr));
	}' unless defined(&insertln);
	eval 'sub instr {
	    my($s) = @_;
    	    eval q( &winstr( &stdscr, $s));
	}' unless defined(&instr);
	eval 'sub move {
	    my($y, $x) = @_;
    	    eval q( &wmove( &stdscr, $y, $x));
	}' unless defined(&move);
	eval 'sub refresh () {
	    eval q( &wrefresh( &stdscr));
	}' unless defined(&refresh);
	eval 'sub scrl {
	    my($n) = @_;
    	    eval q( &wscrl( &stdscr, $n));
	}' unless defined(&scrl);
	eval 'sub setscrreg {
	    my($t, $b) = @_;
    	    eval q( &wsetscrreg( &stdscr, $t, $b));
	}' unless defined(&setscrreg);
	eval 'sub standend () {
	    eval q( &wstandend( &stdscr));
	}' unless defined(&standend);
	eval 'sub standout () {
	    eval q( &wstandout( &stdscr));
	}' unless defined(&standout);
	eval 'sub timeout {
	    my($delay) = @_;
    	    eval q( &wtimeout( &stdscr, $delay));
	}' unless defined(&timeout);
	eval 'sub underscore () {
	    eval q( &wunderscore( &stdscr));
	}' unless defined(&underscore);
	eval 'sub underend () {
	    eval q( &wunderend( &stdscr));
	}' unless defined(&underend);
	eval 'sub waddbytes {
	    my($w, $s, $n) = @_;
    	    eval q( &__waddbytes($w, $s, $n, 0));
	}' unless defined(&waddbytes);
	eval 'sub waddstr {
	    my($w, $s) = @_;
    	    eval q( &waddnstr($w, $s, -1));
	}' unless defined(&waddstr);
	eval 'sub mvaddbytes {
	    my($y, $x, $s, $n) = @_;
    	    eval q( &mvwaddbytes( &stdscr, $y, $x, $s, $n));
	}' unless defined(&mvaddbytes);
	eval 'sub mvaddch {
	    my($y, $x, $ch) = @_;
    	    eval q( &mvwaddch( &stdscr, $y, $x, $ch));
	}' unless defined(&mvaddch);
	eval 'sub mvaddchnstr {
	    my($y, $x, $s, $n) = @_;
    	    eval q( &mvwaddchnstr( &stdscr, $y, $x, $s, $n));
	}' unless defined(&mvaddchnstr);
	eval 'sub mvaddchstr {
	    my($y, $x, $s) = @_;
    	    eval q( &mvwaddchstr( &stdscr, $y, $x, $s));
	}' unless defined(&mvaddchstr);
	eval 'sub mvaddnstr {
	    my($y, $x, $s, $n) = @_;
    	    eval q( &mvwaddnstr( &stdscr, $y, $x, $s, $n));
	}' unless defined(&mvaddnstr);
	eval 'sub mvaddstr {
	    my($y, $x, $s) = @_;
    	    eval q( &mvwaddstr( &stdscr, $y, $x, $s));
	}' unless defined(&mvaddstr);
	eval 'sub mvdelch {
	    my($y, $x) = @_;
    	    eval q( &mvwdelch( &stdscr, $y, $x));
	}' unless defined(&mvdelch);
	eval 'sub mvgetch {
	    my($y, $x) = @_;
    	    eval q( &mvwgetch( &stdscr, $y, $x));
	}' unless defined(&mvgetch);
	eval 'sub mvgetnstr {
	    my($y, $x, $s, $n) = @_;
    	    eval q( &mvwgetnstr( &stdscr, $y, $x, $s, $n));
	}' unless defined(&mvgetnstr);
	eval 'sub mvgetstr {
	    my($y, $x, $s) = @_;
    	    eval q( &mvwgetstr( &stdscr, $y, $x, $s));
	}' unless defined(&mvgetstr);
	eval 'sub mvinch {
	    my($y, $x) = @_;
    	    eval q( &mvwinch( &stdscr, $y, $x));
	}' unless defined(&mvinch);
	eval 'sub mvinchnstr {
	    my($y, $x, $c, $n) = @_;
    	    eval q( &mvwinchnstr( &stdscr, $y, $x, $c, $n));
	}' unless defined(&mvinchnstr);
	eval 'sub mvinchstr {
	    my($y, $x, $c) = @_;
    	    eval q( &mvwinchstr( &stdscr, $y, $x, $c));
	}' unless defined(&mvinchstr);
	eval 'sub mvinnstr {
	    my($y, $x, $s, $n) = @_;
    	    eval q( &mvwinnstr( &stdscr, $y, $x, $s, $n));
	}' unless defined(&mvinnstr);
	eval 'sub mvinsch {
	    my($y, $x, $c) = @_;
    	    eval q( &mvwinsch( &stdscr, $y, $x, $c));
	}' unless defined(&mvinsch);
	eval 'sub mvinstr {
	    my($y, $x, $s) = @_;
    	    eval q( &mvwinstr( &stdscr, $y, $x, $s));
	}' unless defined(&mvinstr);
	eval 'sub mvwaddbytes {
	    my($w, $y, $x, $s, $n) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &__waddbytes($w, $s, $n, 0)));
	}' unless defined(&mvwaddbytes);
	eval 'sub mvwaddch {
	    my($w, $y, $x, $ch) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &waddch($w, $ch)));
	}' unless defined(&mvwaddch);
	eval 'sub mvwaddchnstr {
	    my($w, $y, $x, $s, $n) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &waddchnstr($w, $s, $n)));
	}' unless defined(&mvwaddchnstr);
	eval 'sub mvwaddchstr {
	    my($w, $y, $x, $s) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &waddchnstr($w, $s, -1)));
	}' unless defined(&mvwaddchstr);
	eval 'sub mvwaddnstr {
	    my($w, $y, $x, $s, $n) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &waddnstr($w, $s, $n)));
	}' unless defined(&mvwaddnstr);
	eval 'sub mvwaddstr {
	    my($w, $y, $x, $s) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &waddnstr($w, $s, -1)));
	}' unless defined(&mvwaddstr);
	eval 'sub mvwdelch {
	    my($w, $y, $x) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &wdelch($w)));
	}' unless defined(&mvwdelch);
	eval 'sub mvwgetch {
	    my($w, $y, $x) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &wgetch($w)));
	}' unless defined(&mvwgetch);
	eval 'sub mvwgetnstr {
	    my($w, $y, $x, $s, $n) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &wgetnstr($w, $s, $n)));
	}' unless defined(&mvwgetnstr);
	eval 'sub mvwgetstr {
	    my($w, $y, $x, $s) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &wgetstr($w, $s)));
	}' unless defined(&mvwgetstr);
	eval 'sub mvwinch {
	    my($w, $y, $x) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &winch($w)));
	}' unless defined(&mvwinch);
	eval 'sub mvwinchnstr {
	    my($w, $y, $x, $c, $n) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &winchnstr($w, $c, $n)));
	}' unless defined(&mvwinchnstr);
	eval 'sub mvwinchstr {
	    my($w, $y, $x, $s) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &winchstr($w,  &c)));
	}' unless defined(&mvwinchstr);
	eval 'sub mvwinnstr {
	    my($w, $y, $x, $s, $n) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &winnstr($w, $s, $n)));
	}' unless defined(&mvwinnstr);
	eval 'sub mvwinsch {
	    my($w, $y, $x, $c) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &winsch($w, $c)));
	}' unless defined(&mvwinsch);
	eval 'sub mvwinstr {
	    my($w, $y, $x, $s) = @_;
    	    eval q(( &wmove($w, $y, $x) ==  &ERR ?  &ERR :  &winstr($w, $s)));
	}' unless defined(&mvwinstr);
	eval 'sub noqiflush () {
	    eval q( &intrflush( &stdscr,  &FALSE));
	}' unless defined(&noqiflush);
	eval 'sub qiflush () {
	    eval q( &intrflush( &stdscr,  &TRUE));
	}' unless defined(&qiflush);
    } else {
    }
    eval 'sub getyx {
        my($w, $y, $x) = @_;
	    eval q(($y) =  &getcury($w), ($x) =  &getcurx($w));
    }' unless defined(&getyx);
    eval 'sub getbegyx {
        my($w, $y, $x) = @_;
	    eval q(($y) =  &getbegy($w), ($x) =  &getbegx($w));
    }' unless defined(&getbegyx);
    eval 'sub getmaxyx {
        my($w, $y, $x) = @_;
	    eval q(($y) =  &getmaxy($w), ($x) =  &getmaxx($w));
    }' unless defined(&getmaxyx);
    eval 'sub getparyx {
        my($w, $y, $x) = @_;
	    eval q(($y) =  &getpary($w), ($x) =  &getparx($w));
    }' unless defined(&getparyx);
    eval 'sub getsyx {
        my($y, $x) = @_;
	    eval q( &do {  &if ( &is_leaveok( &curscr)) ($y) = ($x) = -1;  &else  &getyx( &curscr,($y), ($x)); }  &while(0));
    }' unless defined(&getsyx);
    eval 'sub setsyx {
        my($y, $x) = @_;
	    eval q( &do {  &if (($y) == -1 && ($x) == -1)  &leaveok( &curscr,  &TRUE);  &else {  &leaveok( &curscr,  &FALSE);  &wmove( &curscr, ($y), ($x)); } }  &while(0));
    }' unless defined(&setsyx);
    if(defined(&HAVE_WCHAR)) {
    }
}
1;
