/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IndexColorModel
extends ColorModel {
    private int map_size;
    private boolean opaque;
    private int trans;
    private int[] rgb;
    private BigInteger validBits;

    public final int getMapSize() {
        return this.map_size;
    }

    public final int getTransparentPixel() {
        return this.trans;
    }

    public final void getReds(byte[] r) {
        int i = 0;
        while (i < this.map_size) {
            r[i] = (byte)((0xFF0000 & this.rgb[i]) >> 16);
            ++i;
        }
    }

    public final void getGreens(byte[] g) {
        int i = 0;
        while (i < this.map_size) {
            g[i] = (byte)((0xFF00 & this.rgb[i]) >> 8);
            ++i;
        }
    }

    public final void getBlues(byte[] b) {
        int i = 0;
        while (i < this.map_size) {
            b[i] = (byte)(0xFF & this.rgb[i]);
            ++i;
        }
    }

    public final void getAlphas(byte[] a) {
        int i = 0;
        while (i < this.map_size) {
            a[i] = i == this.trans ? (byte)0 : (byte)((0xFF000000 & this.rgb[i]) >> 24);
            ++i;
        }
    }

    public final int getRed(int pixel) {
        if (pixel < this.map_size) {
            return (0xFF0000 & this.rgb[pixel]) >> 16;
        }
        return 0;
    }

    public final int getGreen(int pixel) {
        if (pixel < this.map_size) {
            return (0xFF00 & this.rgb[pixel]) >> 8;
        }
        return 0;
    }

    public final int getBlue(int pixel) {
        if (pixel < this.map_size) {
            return 0xFF & this.rgb[pixel];
        }
        return 0;
    }

    public final int getAlpha(int pixel) {
        if (this.opaque && pixel != this.trans) {
            return 255;
        }
        if (pixel == this.trans && this.trans != -1 || pixel >= this.map_size) {
            return 0;
        }
        return (0xFF000000 & this.rgb[pixel]) >> 24;
    }

    public final int getRGB(int pixel) {
        if (pixel >= 0 && pixel < this.map_size) {
            return this.rgb[pixel];
        }
        return 0;
    }

    public final void getRGBs(int[] rgb) {
        System.arraycopy(this.rgb, 0, rgb, 0, this.map_size);
    }

    public boolean isValid(int pixel) {
        if (pixel >= 0) {
            return this.validBits.testBit(pixel);
        }
        return false;
    }

    public boolean isValid() {
        BigInteger allbits = new BigInteger("0");
        allbits = allbits.setBit(this.map_size);
        allbits = allbits.subtract(new BigInteger("1"));
        return allbits.equals(this.validBits);
    }

    public BigInteger getValidPixels() {
        return this.validBits;
    }

    public BufferedImage convertToIntDiscrete(Raster raster, boolean forceARGB) {
        int n;
        if (forceARGB) {
            n = 2;
        } else {
            int n2 = 0;
            if (this.opaque && this.trans == -1) {
                n2 = 1;
            }
            n = 2 - n2;
        }
        int type = n;
        BufferedImage im = new BufferedImage(raster.width, raster.height, type);
        int x = raster.minX;
        while (x < raster.width + raster.minX) {
            int y = raster.minY;
            while (y < raster.height + raster.minY) {
                im.setRGB(x, y, this.rgb[raster.getSample(x, y, 0)]);
                ++y;
            }
            ++x;
        }
        return im;
    }

    private final /* synthetic */ void this() {
        this.trans = -1;
        this.validBits = BigInteger.ZERO;
    }

    public IndexColorModel(int bits, int size, byte[] reds, byte[] greens, byte[] blues) {
        this(bits, size, reds, greens, blues, null);
    }

    public IndexColorModel(int bits, int size, byte[] reds, byte[] greens, byte[] blues, int trans) {
        int n = 0;
        if (trans >= 0 && trans < size) {
            n = 1;
        }
        int[] nArray = IndexColorModel.nArray(8, n + 3);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        boolean bl = false;
        if (trans >= 0 && trans < size) {
            bl = true;
        }
        super(bits, nArray, colorSpace, bl, false, 1, Buffers.smallestAppropriateTransferType(bits));
        this.this();
        if (bits < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (bits > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = size;
        if (trans >= 0 && trans < size) {
            this.trans = trans;
            this.transparency = 2;
        }
        this.rgb = new int[size];
        int i = 0;
        while (i < size) {
            this.rgb[i] = 0xFF000000 | (reds[i] & 0xFF) << 16 | (greens[i] & 0xFF) << 8 | blues[i] & 0xFF;
            ++i;
        }
        this.validBits = this.validBits.setBit(size).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int bits, int size, byte[] reds, byte[] greens, byte[] blues, byte[] alphas) {
        int n = 0;
        if (alphas == null) {
            n = 1;
        }
        int[] nArray = IndexColorModel.nArray(8, 4 - n);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        boolean bl = false;
        if (alphas != null) {
            bl = true;
        }
        super(bits, nArray, colorSpace, bl, false, 3, Buffers.smallestAppropriateTransferType(bits));
        this.this();
        if (bits < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (bits > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = size;
        boolean bl2 = false;
        if (alphas == null) {
            bl2 = true;
        }
        this.opaque = bl2;
        this.rgb = new int[size];
        if (alphas == null) {
            int i = 0;
            while (i < size) {
                this.rgb[i] = 0xFF000000 | (reds[i] & 0xFF) << 16 | (greens[i] & 0xFF) << 8 | blues[i] & 0xFF;
                ++i;
            }
            this.transparency = 1;
        } else {
            byte alphaZero = 0;
            int alphaOne = -1;
            int i = 0;
            while (i < size) {
                alphaZero = (byte)(alphaZero | alphas[i]);
                alphaOne = (byte)(alphaOne & alphas[i]);
                this.rgb[i] = (alphas[i] & 0xFF) << 24 | (reds[i] & 0xFF) << 16 | (greens[i] & 0xFF) << 8 | blues[i] & 0xFF;
                ++i;
            }
            this.transparency = alphaZero == 0 || alphaOne == -1 ? 2 : 3;
        }
        this.validBits = this.validBits.setBit(size).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int bits, int size, byte[] cmap, int start, boolean hasAlpha) {
        this(bits, size, cmap, start, hasAlpha, -1);
    }

    public IndexColorModel(int bits, int size, byte[] cmap, int start, boolean hasAlpha, int trans) {
        int n = 0;
        if (hasAlpha || trans >= 0 && trans < size) {
            n = 1;
        }
        int[] nArray = IndexColorModel.nArray(8, n + 3);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        boolean bl = false;
        if (hasAlpha || trans >= 0 && trans < size) {
            bl = true;
        }
        super(bits, nArray, colorSpace, bl, false, 1, Buffers.smallestAppropriateTransferType(bits));
        this.this();
        if (bits < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (bits > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = size;
        this.opaque = hasAlpha ^ true;
        if (trans >= 0 && trans < size) {
            this.trans = trans;
        }
        this.rgb = new int[size];
        if (hasAlpha) {
            int alphaZero = 0;
            int alphaOne = 255;
            int i = 0;
            while (i < size) {
                int alpha = cmap[4 * i + 3 + start] & 0xFF;
                alphaZero |= alpha;
                alphaOne &= alpha;
                this.rgb[i] = alpha << 24 | (cmap[4 * i + start] & 0xFF) << 16 | (cmap[4 * i + 1 + start] & 0xFF) << 8 | cmap[4 * i + 2 + start] & 0xFF;
                ++i;
            }
            if (alphaZero == 0) {
                this.transparency = 2;
            } else if (alphaOne == 255) {
                int n2 = 0;
                if (trans != -1) {
                    n2 = 1;
                }
                this.transparency = n2 + 1;
            } else {
                this.transparency = 3;
            }
        } else {
            int i = 0;
            while (i < size) {
                this.rgb[i] = 0xFF000000 | (cmap[3 * i + start] & 0xFF) << 16 | (cmap[3 * i + 1 + start] & 0xFF) << 8 | cmap[3 * i + 2 + start] & 0xFF;
                ++i;
            }
            if (trans != -1) {
                this.transparency = 2;
            }
        }
        this.validBits = this.validBits.setBit(size).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int bits, int size, int[] cmap, int start, boolean hasAlpha, int trans, int transferType) {
        super(bits, IndexColorModel.nArray(8, 4), ColorSpace.getInstance(1000), true, false, 3, transferType);
        this.this();
        if (transferType != 0 && transferType != 1) {
            throw new IllegalArgumentException();
        }
        if (bits > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = size;
        this.opaque = hasAlpha ^ true;
        if (trans >= 0 && trans < size) {
            this.trans = trans;
        }
        this.rgb = new int[size];
        if (!hasAlpha) {
            int i = 0;
            while (i < size) {
                this.rgb[i] = cmap[i + start] | 0xFF000000;
                ++i;
            }
        } else {
            System.arraycopy(cmap, start, this.rgb, 0, size);
        }
        this.validBits = this.validBits.setBit(size).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int bits, int size, int[] cmap, int start, int transferType, BigInteger validBits) {
        super(bits, IndexColorModel.nArray(8, 4), ColorSpace.getInstance(1000), true, false, 3, transferType);
        this.this();
        if (transferType != 0 && transferType != 1) {
            throw new IllegalArgumentException();
        }
        if (bits > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = size;
        this.opaque = false;
        this.trans = -1;
        this.validBits = validBits;
        this.rgb = new int[size];
        if (!this.hasAlpha) {
            int i = 0;
            while (i < size) {
                this.rgb[i] = cmap[i + start] | 0xFF000000;
                ++i;
            }
        } else {
            System.arraycopy(cmap, start, this.rgb, 0, size);
        }
    }
}

